/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.store.MailMessageAttributes;
import com.icegreen.greenmail.store.SimpleMessageAttributes;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class StoredMessage {
    private UidAwareMimeMessage mimeMessage;
    private Date receivedDate;
    private long uid;
    private SimpleMessageAttributes attributes;

    StoredMessage(MimeMessage mimeMessage, Date receivedDate, long uid) {
        this.receivedDate = receivedDate;
        this.uid = uid;
        try {
            this.mimeMessage = new UidAwareMimeMessage(mimeMessage, uid, receivedDate);
            this.attributes = new SimpleMessageAttributes(mimeMessage, receivedDate);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Could not parse mime message " + mimeMessage + " with uid " + uid, e);
        }
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public Flags getFlags() {
        try {
            return this.getMimeMessage().getFlags();
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not access flags", e);
        }
    }

    public boolean isSet(Flags.Flag flag) {
        try {
            return this.getMimeMessage().isSet(flag);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not access flag " + flag, e);
        }
    }

    public void setFlag(Flags.Flag flag, boolean value) {
        try {
            this.getMimeMessage().setFlag(flag, value);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not set flag " + flag + " to " + value, e);
        }
    }

    public void setFlags(Flags flags, boolean value) {
        try {
            this.getMimeMessage().setFlags(flags, value);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not set flags " + flags + " to " + value, e);
        }
    }

    public Date getReceivedDate() {
        return this.receivedDate;
    }

    public long getUid() {
        return this.uid;
    }

    public MailMessageAttributes getAttributes() {
        return this.attributes;
    }

    public void updateMessageNumber(int messageNumber) {
        this.mimeMessage.updateMessageNumber(messageNumber);
    }

    public static class UidAwareMimeMessage
    extends MimeMessage {
        private long uid;
        private Date receivedDate;

        public UidAwareMimeMessage(MimeMessage source, long uid, Date receivedDate) throws MessagingException {
            super(source);
            this.uid = uid;
            this.receivedDate = receivedDate;
        }

        @Override
        public Date getReceivedDate() {
            return this.receivedDate;
        }

        public long getUid() {
            return this.uid;
        }

        public void updateMessageNumber(int messageNumber) {
            this.setMessageNumber(messageNumber);
        }
    }
}

