/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.configuration;

import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import java.util.Arrays;
import java.util.Properties;

public class PropertiesBasedGreenMailConfigurationBuilder {
    public static final String GREENMAIL_USERS = "greenmail.users";
    public static final String GREENMAIL_AUTH_DISABLED = "greenmail.auth.disabled";

    public GreenMailConfiguration build(Properties properties) {
        String disabledAuthentication;
        GreenMailConfiguration configuration = new GreenMailConfiguration();
        String usersParam = properties.getProperty(GREENMAIL_USERS);
        if (null != usersParam) {
            String[] usersArray;
            for (String user : usersArray = usersParam.split(",")) {
                this.extractAndAddUser(configuration, user);
            }
        }
        if (null != (disabledAuthentication = properties.getProperty(GREENMAIL_AUTH_DISABLED))) {
            configuration.withDisabledAuthentication();
        }
        return configuration;
    }

    protected void extractAndAddUser(GreenMailConfiguration configuration, String user) {
        Object[] userParts = user.split(":|@");
        switch (userParts.length) {
            case 2: {
                configuration.withUser(userParts[0], userParts[1]);
                break;
            }
            case 3: {
                configuration.withUser(userParts[0] + '@' + userParts[2], (String)userParts[0], (String)userParts[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected format login:pwd[@domain] but got " + user + " parsed to " + Arrays.toString(userParts));
            }
        }
    }
}

