/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.mail;

import com.icegreen.greenmail.foedus.util.Resource;
import com.icegreen.greenmail.foedus.util.Workspace;
import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.MimeMessage;

public class MovingMessage {
    private MailAddress returnPath;
    private List<MailAddress> toAddresses = new LinkedList<MailAddress>();
    private Workspace workspace;
    private Resource content;
    private MimeMessage message;
    private int references = 0;

    public MovingMessage(Workspace workspace) {
        this.workspace = workspace;
    }

    public List<MailAddress> getToAddresses() {
        return this.toAddresses;
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public Reader getContent() throws IOException {
        return this.content.getReader();
    }

    public void acquire() {
        ++this.references;
    }

    public void releaseContent() {
        if (this.references > 0) {
            --this.references;
        } else if (this.content != null) {
            this.workspace.release(this.content);
            this.content = null;
        }
    }

    public MailAddress getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(MailAddress fromAddress) {
        this.returnPath = fromAddress;
    }

    public void addRecipient(MailAddress s) {
        this.toAddresses.add(s);
    }

    public void removeRecipient(MailAddress s) {
        this.toAddresses.remove(s);
    }

    public void readDotTerminatedContent(BufferedReader in) throws IOException {
        this.content = this.workspace.getTmpFile();
        Writer data = this.content.getWriter();
        InternetPrintWriter dataWriter = new InternetPrintWriter(data);
        while (true) {
            String line;
            if ((line = in.readLine()) == null) {
                throw new EOFException("Did not receive <CRLF>.<CRLF>");
            }
            if (".".equals(line)) break;
            if (line.startsWith(".")) {
                ((PrintWriter)dataWriter).println(line.substring(1));
                continue;
            }
            ((PrintWriter)dataWriter).println(line);
        }
        dataWriter.close();
        try {
            this.message = GreenMailUtil.newMimeMessage(this.content.getAsString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

