/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.user.UserManager;
import com.sun.mail.util.BASE64DecoderStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class AuthCommand
extends SmtpCommand {
    public static final String AUTH_SUCCEDED = "235 2.7.0  Authentication Succeeded";
    public static final String AUTH_CREDENTIALS_INVALID = "535 5.7.8  Authentication credentials invalid";
    public static final String AUTH_ALREADY_AUTHENTICATED = "503 already authenticated";
    public static final String SMTP_SYNTAX_ERROR = "500 syntax error";
    public static final String SMTP_SERVER_CONTINUATION = "334 ";
    public static final String SUPPORTED_AUTH_MECHANISM = AuthCommand.getValuesWsSeparated();

    @Override
    public void execute(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine) throws IOException {
        String initialResponse;
        if (conn.isAuthenticated()) {
            conn.send(AUTH_ALREADY_AUTHENTICATED);
            return;
        }
        String[] commandParts = commandLine.split(" ");
        if (commandParts.length < 2) {
            conn.send("500 syntax error : expected mechanism but received <" + commandLine + ">");
            return;
        }
        String authMechanismValue = commandParts[1];
        if (!AuthMechanism.PLAIN.name().equalsIgnoreCase(authMechanismValue)) {
            conn.send("500 syntax error : Unsupported auth mechanism " + authMechanismValue + ". Only auth mechanism <" + Arrays.toString((Object[])AuthMechanism.values()) + "> supported.");
            return;
        }
        AuthMechanism authMechanism = AuthMechanism.PLAIN;
        if (commandParts.length == 2) {
            conn.send(SMTP_SERVER_CONTINUATION);
            initialResponse = conn.receiveLine();
        } else {
            initialResponse = commandParts[2];
        }
        if (this.authenticate(manager.getUserManager(), authMechanism, initialResponse)) {
            conn.setAuthenticated(true);
            conn.send(AUTH_SUCCEDED);
        } else {
            conn.send(AUTH_CREDENTIALS_INVALID);
        }
    }

    private boolean authenticate(UserManager userManager, AuthMechanism authMechanism, String value) {
        if (AuthMechanism.PLAIN == authMechanism) {
            BASE64DecoderStream stream = new BASE64DecoderStream((InputStream)new ByteArrayInputStream(value.getBytes(StandardCharsets.US_ASCII)));
            this.readTillNullChar(stream);
            String authenticationId = this.readTillNullChar(stream);
            String passwd = this.readTillNullChar(stream);
            return userManager.test(authenticationId, passwd);
        }
        return false;
    }

    @Deprecated
    private String readTillNullChar(BASE64DecoderStream stream) {
        try {
            StringBuilder buf = new StringBuilder();
            int chr = stream.read();
            while (chr != 0 && chr > 0) {
                buf.append((char)chr);
                chr = stream.read();
            }
            return buf.toString();
        }
        catch (IOException e) {
            this.log.error("Can not decode", (Throwable)e);
            return null;
        }
    }

    private static String getValuesWsSeparated() {
        StringBuilder buf = new StringBuilder();
        for (AuthMechanism mechanism : AuthMechanism.values()) {
            buf.append((Object)mechanism);
        }
        return buf.toString();
    }

    public static enum AuthMechanism {
        PLAIN;

    }
}

