/*
 * Decompiled with CFR 0.152.
 */
package butterknife;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.util.Log;
import android.util.Property;
import android.view.View;
import butterknife.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ButterKnife {
    private static final String TAG = "ButterKnife";
    private static boolean debug = false;
    static final Map<Class<?>, Injector<Object>> INJECTORS = new LinkedHashMap();
    static final Injector<Object> NOP_INJECTOR = new Injector<Object>(){

        @Override
        public void inject(Finder finder, Object target, Object source) {
        }

        @Override
        public void reset(Object target) {
        }
    };

    private ButterKnife() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void setDebug(boolean debug) {
        ButterKnife.debug = debug;
    }

    public static void inject(Activity target) {
        ButterKnife.inject(target, target, Finder.ACTIVITY);
    }

    public static void inject(View target) {
        ButterKnife.inject(target, target, Finder.VIEW);
    }

    public static void inject(Dialog target) {
        ButterKnife.inject(target, target, Finder.DIALOG);
    }

    public static void inject(Object target, Activity source) {
        ButterKnife.inject(target, source, Finder.ACTIVITY);
    }

    public static void inject(Object target, View source) {
        ButterKnife.inject(target, source, Finder.VIEW);
    }

    public static void inject(Object target, Dialog source) {
        ButterKnife.inject(target, source, Finder.DIALOG);
    }

    public static void reset(Object target) {
        Class<?> targetClass = target.getClass();
        try {
            Injector<Object> injector;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view injector for " + targetClass.getName()));
            }
            if ((injector = ButterKnife.findInjectorForClass(targetClass)) != null) {
                injector.reset(target);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reset views for " + target, e);
        }
    }

    static void inject(Object target, Object source, Finder finder) {
        Class<?> targetClass = target.getClass();
        try {
            Injector<Object> injector;
            if (debug) {
                Log.d((String)TAG, (String)("Looking up view injector for " + targetClass.getName()));
            }
            if ((injector = ButterKnife.findInjectorForClass(targetClass)) != null) {
                injector.inject(finder, target, source);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to inject views for " + target, e);
        }
    }

    private static Injector<Object> findInjectorForClass(Class<?> cls) throws IllegalAccessException, InstantiationException {
        Injector injector = INJECTORS.get(cls);
        if (injector != null) {
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Cached in injector map.");
            }
            return injector;
        }
        String clsName = cls.getName();
        if (clsName.startsWith("android.") || clsName.startsWith("java.")) {
            if (debug) {
                Log.d((String)TAG, (String)"MISS: Reached framework class. Abandoning search.");
            }
            return NOP_INJECTOR;
        }
        try {
            Class<?> injectorClass = Class.forName(clsName + "$$ViewInjector");
            injector = (Injector)injectorClass.newInstance();
            if (debug) {
                Log.d((String)TAG, (String)"HIT: Class loaded injection class.");
            }
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                Log.d((String)TAG, (String)("Not found. Trying superclass " + cls.getSuperclass().getName()));
            }
            injector = ButterKnife.findInjectorForClass(cls.getSuperclass());
        }
        INJECTORS.put(cls, injector);
        return injector;
    }

    public static <T extends View> void apply(List<T> list, Action<? super T> action) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            action.apply((View)list.get(i), i);
        }
    }

    public static <T extends View, V> void apply(List<T> list, Setter<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set((View)list.get(i), value, i);
        }
    }

    @TargetApi(value=14)
    public static <T extends View, V> void apply(List<T> list, Property<? super T, V> setter, V value) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            setter.set(list.get(i), value);
        }
    }

    public static <T extends View> T findById(View view, int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findById(Activity activity, int id) {
        return (T)activity.findViewById(id);
    }

    public static <T extends View> T findById(Dialog dialog, int id) {
        return (T)dialog.findViewById(id);
    }

    public static interface Setter<T extends View, V> {
        public void set(T var1, V var2, int var3);
    }

    public static interface Action<T extends View> {
        public void apply(T var1, int var2);
    }

    public static interface Injector<T> {
        public void inject(Finder var1, T var2, Object var3);

        public void reset(T var1);
    }

    public static enum Finder {
        VIEW{

            @Override
            protected View findView(Object source, int id) {
                return ((View)source).findViewById(id);
            }

            @Override
            protected Context getContext(Object source) {
                return ((View)source).getContext();
            }
        }
        ,
        ACTIVITY{

            @Override
            protected View findView(Object source, int id) {
                return ((Activity)source).findViewById(id);
            }

            @Override
            protected Context getContext(Object source) {
                return (Activity)source;
            }
        }
        ,
        DIALOG{

            @Override
            protected View findView(Object source, int id) {
                return ((Dialog)source).findViewById(id);
            }

            @Override
            protected Context getContext(Object source) {
                return ((Dialog)source).getContext();
            }
        };


        public static <T> T[] arrayOf(T ... views) {
            return views;
        }

        public static <T> List<T> listOf(T ... views) {
            return new ImmutableList<T>(views);
        }

        public <T> T findRequiredView(Object source, int id, String who) {
            T view = this.findOptionalView(source, id, who);
            if (view == null) {
                String name = this.getContext(source).getResources().getResourceEntryName(id);
                throw new IllegalStateException("Required view '" + name + "' with ID " + id + " for " + who + " was not found. If this view is optional add '@Optional' annotation.");
            }
            return view;
        }

        public <T> T findOptionalView(Object source, int id, String who) {
            View view = this.findView(source, id);
            return this.castView(view, id, who);
        }

        public <T> T castView(View view, int id, String who) {
            try {
                return (T)view;
            }
            catch (ClassCastException e) {
                if (who == null) {
                    throw new AssertionError();
                }
                String name = view.getResources().getResourceEntryName(id);
                throw new IllegalStateException("View '" + name + "' with ID " + id + " for " + who + " was of the wrong type. See cause for more info.", e);
            }
        }

        public <T> T castParam(Object value, String from, int fromPosition, String to, int toPosition) {
            try {
                return (T)value;
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Parameter #" + (fromPosition + 1) + " of method '" + from + "' was of the wrong type for parameter #" + (toPosition + 1) + " of method '" + to + "'. See cause for more info.", e);
            }
        }

        protected abstract View findView(Object var1, int var2);

        protected abstract Context getContext(Object var1);
    }
}

