/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Cholesky;
import com.stripe.rainier.compute.Real;
import com.stripe.rainier.compute.Real$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

public final class Cholesky$
implements Serializable {
    public static final Cholesky$ MODULE$ = new Cholesky$();

    public int triangleNumber(int k) {
        return k * (k + 1) / 2;
    }

    public void lowerTriangularMultiply(double[] packed, double[] vector, double[] result) {
        int n = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(result));
        int i = 0;
        int base = 0;
        while (i < n) {
            double acc = 0.0;
            for (int j = 0; j <= i; ++j) {
                acc += vector[j] * packed[base + j];
            }
            result[i] = acc;
            base += ++i;
        }
    }

    private int packedIndex(int i, int j) {
        return this.triangleNumber(i) + j;
    }

    public int dimension(int packedSize) {
        return (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(Math.sqrt((double)packedSize * 2.0)));
    }

    public Vector<Real> lowerTriangularSolve(Vector<Real> packed, Vector<Real> y) {
        return (Vector)((LinearSeqOps)y.toList().zipWithIndex()).foldLeft((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Vector xAcc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    xAcc = (Vector)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Real yi = (Real)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Vector row = (Vector)packed.slice(MODULE$.triangleNumber(i), MODULE$.triangleNumber(i + 1));
            Real dot = Real$.MODULE$.sum((Iterable<Real>)((Iterable)((StrictOptimizedIterableOps)row.init().zip((IterableOnce)xAcc)).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Real a = (Real)tuple2._1();
                Real b = (Real)tuple2._2();
                Real real = a.$times(b);
                return real;
            })));
            Real xi = yi.$minus(dot).$div((Real)row.last());
            Vector vector = (Vector)xAcc.$colon$plus((Object)xi);
            return vector;
        });
    }

    public Vector<Real> upperTriangularSolve(Vector<Real> packed, Vector<Real> y) {
        return (Vector)this.lowerTriangularSolve(this.reflect(packed), (Vector<Real>)((Vector)y.reverse())).reverse();
    }

    private Vector<Real> reflect(Vector<Real> packed) {
        int n = this.dimension(packed.size());
        return ((IterableOnceOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).flatMap((Function1 & Serializable)i -> Cholesky$.$anonfun$reflect$1(packed, n, BoxesRunTime.unboxToInt((Object)i)))).toVector();
    }

    public Cholesky apply(Vector<Real> packed) {
        return new Cholesky(packed);
    }

    public Option<Vector<Real>> unapply(Cholesky x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.packed());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Cholesky$.class);
    }

    public static final /* synthetic */ Real $anonfun$reflect$2(Vector packed$2, int n$1, int i$1, int j) {
        return (Real)packed$2.apply(MODULE$.packedIndex(n$1 - j - 1, n$1 - i$1 - 1));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$reflect$1(Vector packed$2, int n$1, int i) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), i).map((Function1 & Serializable)j -> Cholesky$.$anonfun$reflect$2(packed$2, n$1, i, BoxesRunTime.unboxToInt((Object)j)));
    }

    private Cholesky$() {
    }
}

