/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Decimal;
import com.stripe.rainier.compute.DoubleDecimal;
import com.stripe.rainier.compute.FractionDecimal;
import com.stripe.rainier.compute.Infinity$;
import com.stripe.rainier.compute.NegInfinity$;
import scala.Predef$;
import scala.runtime.RichDouble$;

public final class Decimal$ {
    public static final Decimal$ MODULE$ = new Decimal$();
    private static final Decimal Zero = MODULE$.apply(0);
    private static final Decimal One = MODULE$.apply(1);
    private static final Decimal Two = MODULE$.apply(2);
    private static final Decimal Pi = MODULE$.apply(Math.PI);

    public Decimal apply(double value) {
        Decimal decimal;
        if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(value))) {
            decimal = Infinity$.MODULE$;
        } else if (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(value))) {
            decimal = NegInfinity$.MODULE$;
        } else {
            if (Double.isNaN(value)) {
                throw new ArithmeticException("Produced NaN");
            }
            decimal = new DoubleDecimal(value);
        }
        return decimal;
    }

    public Decimal apply(int value) {
        return new FractionDecimal(value, 1.0);
    }

    public Decimal apply(long value) {
        return new FractionDecimal(value, 1.0);
    }

    public Decimal Zero() {
        return Zero;
    }

    public Decimal One() {
        return One;
    }

    public Decimal Two() {
        return Two;
    }

    public Decimal Pi() {
        return Pi;
    }

    private Decimal$() {
    }
}

