/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Decimal;
import com.stripe.rainier.compute.Decimal$;
import com.stripe.rainier.compute.DoubleDecimal;
import com.stripe.rainier.compute.FractionDecimal;
import com.stripe.rainier.compute.Infinity$;
import com.stripe.rainier.compute.NegInfinity$;
import com.stripe.rainier.ir.AbsOp$;
import com.stripe.rainier.ir.AcosOp$;
import com.stripe.rainier.ir.AsinOp$;
import com.stripe.rainier.ir.AtanOp$;
import com.stripe.rainier.ir.CosOp$;
import com.stripe.rainier.ir.ExpOp$;
import com.stripe.rainier.ir.LogOp$;
import com.stripe.rainier.ir.NoOp$;
import com.stripe.rainier.ir.SinOp$;
import com.stripe.rainier.ir.TanOp$;
import com.stripe.rainier.ir.UnaryOp;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.RichDouble$;

public final class DecimalOps$ {
    public static final DecimalOps$ MODULE$ = new DecimalOps$();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Decimal add(Decimal x, Decimal y) {
        Decimal d;
        Decimal d2;
        Decimal decimal;
        Decimal decimal2;
        Decimal decimal3;
        void var3_16;
        Decimal decimal4;
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            Decimal decimal5 = (Decimal)tuple2._1();
            Decimal decimal6 = (Decimal)tuple2._2();
            if (Infinity$.MODULE$.$eq$eq(decimal5) && NegInfinity$.MODULE$.$eq$eq(decimal6)) {
                throw new ArithmeticException("Cannot add +inf and -inf");
            }
        }
        if (tuple2 != null) {
            Decimal decimal7 = (Decimal)tuple2._1();
            Decimal decimal8 = (Decimal)tuple2._2();
            if (NegInfinity$.MODULE$.$eq$eq(decimal7) && Infinity$.MODULE$.$eq$eq(decimal8)) {
                throw new ArithmeticException("Cannot add +inf and -inf");
            }
        }
        if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal4 = (Decimal)tuple2._1())) {
            Infinity$ infinity$ = Infinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal3 = (Decimal)tuple2._1())) {
            NegInfinity$ negInfinity$ = NegInfinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal2 = (Decimal)tuple2._2())) {
            Infinity$ infinity$ = Infinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal = (Decimal)tuple2._2())) {
            NegInfinity$ negInfinity$ = NegInfinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && (d2 = (Decimal)tuple2._1()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d2;
            Decimal decimal9 = Decimal$.MODULE$.apply(doubleDecimal.toDouble() + y.toDouble());
            return var3_16;
        } else if (tuple2 != null && (d = (Decimal)tuple2._2()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d;
            Decimal decimal10 = Decimal$.MODULE$.apply(doubleDecimal.toDouble() + x.toDouble());
            return var3_16;
        } else {
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Decimal f = (Decimal)tuple2._1();
            Decimal g = (Decimal)tuple2._2();
            if (!(f instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal = (FractionDecimal)f;
            if (!(g instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal2 = (FractionDecimal)g;
            double d3 = this.lcm(fractionDecimal.d(), fractionDecimal2.d());
            double n = fractionDecimal.n() * d3 / fractionDecimal.d() + fractionDecimal2.n() * d3 / fractionDecimal2.d();
            FractionDecimal fractionDecimal3 = new FractionDecimal(n, d3);
        }
        return var3_16;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Decimal subtract(Decimal x, Decimal y) {
        Decimal d;
        Decimal d2;
        Decimal decimal;
        Decimal decimal2;
        Decimal decimal3;
        void var3_16;
        Decimal decimal4;
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            Decimal decimal5 = (Decimal)tuple2._1();
            Decimal decimal6 = (Decimal)tuple2._2();
            if (Infinity$.MODULE$.$eq$eq(decimal5) && Infinity$.MODULE$.$eq$eq(decimal6)) {
                throw new ArithmeticException("Cannot subtract inf and inf");
            }
        }
        if (tuple2 != null) {
            Decimal decimal7 = (Decimal)tuple2._1();
            Decimal decimal8 = (Decimal)tuple2._2();
            if (NegInfinity$.MODULE$.$eq$eq(decimal7) && NegInfinity$.MODULE$.$eq$eq(decimal8)) {
                throw new ArithmeticException("Cannot subtract -inf and -inf");
            }
        }
        if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal4 = (Decimal)tuple2._1())) {
            Infinity$ infinity$ = Infinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal3 = (Decimal)tuple2._1())) {
            NegInfinity$ negInfinity$ = NegInfinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal2 = (Decimal)tuple2._2())) {
            NegInfinity$ negInfinity$ = NegInfinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal = (Decimal)tuple2._2())) {
            Infinity$ infinity$ = Infinity$.MODULE$;
            return var3_16;
        } else if (tuple2 != null && (d2 = (Decimal)tuple2._1()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d2;
            Decimal decimal9 = Decimal$.MODULE$.apply(doubleDecimal.toDouble() - y.toDouble());
            return var3_16;
        } else if (tuple2 != null && (d = (Decimal)tuple2._2()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d;
            Decimal decimal10 = Decimal$.MODULE$.apply(x.toDouble() - doubleDecimal.toDouble());
            return var3_16;
        } else {
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Decimal f = (Decimal)tuple2._1();
            Decimal g = (Decimal)tuple2._2();
            if (!(f instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal = (FractionDecimal)f;
            if (!(g instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal2 = (FractionDecimal)g;
            double d3 = this.lcm(fractionDecimal.d(), fractionDecimal2.d());
            double n = fractionDecimal.n() * d3 / fractionDecimal.d() - fractionDecimal2.n() * d3 / fractionDecimal2.d();
            FractionDecimal fractionDecimal3 = new FractionDecimal(n, d3);
        }
        return var3_16;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Decimal multiply(Decimal x, Decimal y) {
        Decimal d;
        Decimal d2;
        Decimal decimal;
        Decimal decimal2;
        Decimal decimal3;
        void var3_20;
        Decimal decimal4;
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            Decimal decimal5 = (Decimal)tuple2._1();
            Decimal decimal6 = (Decimal)tuple2._2();
            if (NegInfinity$.MODULE$.$eq$eq(decimal5) && Decimal$.MODULE$.Zero().$eq$eq(decimal6)) {
                throw new ArithmeticException("Cannot multiply -inf by zero");
            }
        }
        if (tuple2 != null) {
            Decimal decimal7 = (Decimal)tuple2._1();
            Decimal decimal8 = (Decimal)tuple2._2();
            if (Infinity$.MODULE$.$eq$eq(decimal7) && Decimal$.MODULE$.Zero().$eq$eq(decimal8)) {
                throw new ArithmeticException("Cannot multiply +inf by zero");
            }
        }
        if (tuple2 != null) {
            Decimal decimal9 = (Decimal)tuple2._1();
            Decimal decimal10 = (Decimal)tuple2._2();
            if (Decimal$.MODULE$.Zero().$eq$eq(decimal9) && NegInfinity$.MODULE$.$eq$eq(decimal10)) {
                throw new ArithmeticException("Cannot multiply -inf by zero");
            }
        }
        if (tuple2 != null) {
            Decimal decimal11 = (Decimal)tuple2._1();
            Decimal decimal12 = (Decimal)tuple2._2();
            if (Decimal$.MODULE$.Zero().$eq$eq(decimal11) && Infinity$.MODULE$.$eq$eq(decimal12)) {
                throw new ArithmeticException("Cannot multiply +inf by zero");
            }
        }
        if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal4 = (Decimal)tuple2._1())) {
            Decimal decimal13 = y.$greater(Decimal$.MODULE$.Zero()) ? Infinity$.MODULE$ : NegInfinity$.MODULE$;
            return var3_20;
        } else if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal3 = (Decimal)tuple2._2())) {
            Decimal decimal14 = x.$greater(Decimal$.MODULE$.Zero()) ? Infinity$.MODULE$ : NegInfinity$.MODULE$;
            return var3_20;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal2 = (Decimal)tuple2._1())) {
            Decimal decimal15 = y.$greater(Decimal$.MODULE$.Zero()) ? NegInfinity$.MODULE$ : Infinity$.MODULE$;
            return var3_20;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal = (Decimal)tuple2._2())) {
            Decimal decimal16 = x.$greater(Decimal$.MODULE$.Zero()) ? NegInfinity$.MODULE$ : Infinity$.MODULE$;
            return var3_20;
        } else if (tuple2 != null && (d2 = (Decimal)tuple2._1()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d2;
            Decimal decimal17 = Decimal$.MODULE$.apply(doubleDecimal.toDouble() * y.toDouble());
            return var3_20;
        } else if (tuple2 != null && (d = (Decimal)tuple2._2()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d;
            Decimal decimal18 = Decimal$.MODULE$.apply(x.toDouble() * doubleDecimal.toDouble());
            return var3_20;
        } else {
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Decimal f = (Decimal)tuple2._1();
            Decimal g = (Decimal)tuple2._2();
            if (!(f instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal = (FractionDecimal)f;
            if (!(g instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal2 = (FractionDecimal)g;
            double n = fractionDecimal.n() * fractionDecimal2.n();
            double d3 = fractionDecimal.d() * fractionDecimal2.d();
            double gc = this.gcd(n, d3);
            FractionDecimal fractionDecimal3 = new FractionDecimal(n / gc, d3 / gc);
        }
        return var3_20;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Decimal divide(Decimal x, Decimal y) {
        Decimal d;
        Decimal d2;
        Decimal decimal;
        Decimal decimal2;
        Decimal decimal3;
        void var3_22;
        Decimal decimal4;
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            Decimal decimal5 = (Decimal)tuple2._1();
            Decimal decimal6 = (Decimal)tuple2._2();
            if (Decimal$.MODULE$.Zero().$eq$eq(decimal5) && Decimal$.MODULE$.Zero().$eq$eq(decimal6)) {
                throw new ArithmeticException("Cannot divide zero by zero");
            }
        }
        if (tuple2 != null) {
            Decimal decimal7 = (Decimal)tuple2._1();
            Decimal decimal8 = (Decimal)tuple2._2();
            if (Infinity$.MODULE$.$eq$eq(decimal7) && NegInfinity$.MODULE$.$eq$eq(decimal8)) {
                throw new ArithmeticException("Cannot divide inf by -inf");
            }
        }
        if (tuple2 != null) {
            Decimal decimal9 = (Decimal)tuple2._1();
            Decimal decimal10 = (Decimal)tuple2._2();
            if (NegInfinity$.MODULE$.$eq$eq(decimal9) && Infinity$.MODULE$.$eq$eq(decimal10)) {
                throw new ArithmeticException("Cannot divide -inf by inf");
            }
        }
        if (tuple2 != null) {
            Decimal decimal11 = (Decimal)tuple2._1();
            Decimal decimal12 = (Decimal)tuple2._2();
            if (Infinity$.MODULE$.$eq$eq(decimal11) && Infinity$.MODULE$.$eq$eq(decimal12)) {
                throw new ArithmeticException("Cannot divide inf by inf");
            }
        }
        if (tuple2 != null) {
            Decimal decimal13 = (Decimal)tuple2._1();
            Decimal decimal14 = (Decimal)tuple2._2();
            if (NegInfinity$.MODULE$.$eq$eq(decimal13) && NegInfinity$.MODULE$.$eq$eq(decimal14)) {
                throw new ArithmeticException("Cannot divide -inf by -inf");
            }
        }
        if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal4 = (Decimal)tuple2._1())) {
            Decimal decimal15 = y.$greater(Decimal$.MODULE$.Zero()) ? Infinity$.MODULE$ : NegInfinity$.MODULE$;
            return var3_22;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal3 = (Decimal)tuple2._1())) {
            Decimal decimal16 = y.$greater(Decimal$.MODULE$.Zero()) ? NegInfinity$.MODULE$ : Infinity$.MODULE$;
            return var3_22;
        } else if (tuple2 != null && Infinity$.MODULE$.$eq$eq(decimal2 = (Decimal)tuple2._2())) {
            Decimal decimal17 = Decimal$.MODULE$.Zero();
            return var3_22;
        } else if (tuple2 != null && NegInfinity$.MODULE$.$eq$eq(decimal = (Decimal)tuple2._2())) {
            Decimal decimal18 = Decimal$.MODULE$.Zero();
            return var3_22;
        } else if (tuple2 != null && (d2 = (Decimal)tuple2._1()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d2;
            Decimal decimal19 = Decimal$.MODULE$.apply(doubleDecimal.toDouble() / y.toDouble());
            return var3_22;
        } else if (tuple2 != null && (d = (Decimal)tuple2._2()) instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)d;
            Decimal decimal20 = Decimal$.MODULE$.apply(x.toDouble() / doubleDecimal.toDouble());
            return var3_22;
        } else {
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Decimal f = (Decimal)tuple2._1();
            Decimal g = (Decimal)tuple2._2();
            if (!(f instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal = (FractionDecimal)f;
            if (!(g instanceof FractionDecimal)) throw new MatchError((Object)tuple2);
            FractionDecimal fractionDecimal2 = (FractionDecimal)g;
            double n = fractionDecimal.n() * fractionDecimal2.d();
            double d3 = fractionDecimal.d() * fractionDecimal2.n();
            double gc = this.gcd(n, d3);
            FractionDecimal fractionDecimal3 = new FractionDecimal(n / gc, d3 / gc);
        }
        return var3_22;
    }

    public Decimal abs(Decimal x) {
        Decimal decimal;
        Decimal decimal2 = x;
        if (Infinity$.MODULE$.$eq$eq(decimal2)) {
            decimal = Infinity$.MODULE$;
        } else if (NegInfinity$.MODULE$.$eq$eq(decimal2)) {
            decimal = Infinity$.MODULE$;
        } else if (decimal2 instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)decimal2;
            decimal = Decimal$.MODULE$.apply(Math.abs(doubleDecimal.toDouble()));
        } else if (decimal2 instanceof FractionDecimal) {
            FractionDecimal fractionDecimal = (FractionDecimal)decimal2;
            decimal = new FractionDecimal(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fractionDecimal.n())), RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(fractionDecimal.d())));
        } else {
            throw new MatchError((Object)decimal2);
        }
        return decimal;
    }

    public Decimal pow(Decimal x, int y) {
        Decimal decimal;
        Decimal decimal2 = x;
        if (Infinity$.MODULE$.$eq$eq(decimal2)) {
            decimal = y == 0 ? Decimal$.MODULE$.One() : (y > 0 ? Infinity$.MODULE$ : Decimal$.MODULE$.Zero());
        } else if (NegInfinity$.MODULE$.$eq$eq(decimal2)) {
            decimal = y > 0 ? (y % 2 == 0 ? Infinity$.MODULE$ : NegInfinity$.MODULE$) : Decimal$.MODULE$.Zero();
        } else if (decimal2 instanceof DoubleDecimal) {
            DoubleDecimal doubleDecimal = (DoubleDecimal)decimal2;
            decimal = Decimal$.MODULE$.apply(Math.pow(doubleDecimal.toDouble(), y));
        } else if (decimal2 instanceof FractionDecimal) {
            FractionDecimal fractionDecimal = (FractionDecimal)decimal2;
            double yabs = Math.abs(y);
            double n2 = Math.pow(fractionDecimal.n(), yabs);
            double d2 = Math.pow(fractionDecimal.d(), yabs);
            decimal = y >= 0 ? new FractionDecimal(n2, d2) : new FractionDecimal(d2, n2);
        } else {
            throw new MatchError((Object)decimal2);
        }
        return decimal;
    }

    public Decimal pow(Decimal a, Decimal b) {
        Decimal decimal;
        if (b.isValidInt()) {
            decimal = this.pow(a, b.toInt());
        } else {
            if (a.$less(Decimal$.MODULE$.Zero())) {
                throw new ArithmeticException(new StringBuilder(14).append("Undefined: ").append(a).append(" ^ ").append(b).toString());
            }
            decimal = Decimal$.MODULE$.apply(Math.pow(a.toDouble(), b.toDouble()));
        }
        return decimal;
    }

    public Decimal unary(Decimal x, UnaryOp op) {
        Decimal decimal;
        Decimal decimal2 = x;
        if (Infinity$.MODULE$.$eq$eq(decimal2)) {
            Decimal decimal3;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                decimal3 = Infinity$.MODULE$;
            } else if (LogOp$.MODULE$.equals(unaryOp)) {
                decimal3 = Infinity$.MODULE$;
            } else if (AbsOp$.MODULE$.equals(unaryOp)) {
                decimal3 = Infinity$.MODULE$;
            } else {
                if (SinOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("No limit for 'sin' at positive infinity");
                }
                if (CosOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("No limit for 'cos' at positive infinity");
                }
                if (TanOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("No limit for 'tan' at positive infinity");
                }
                if (AcosOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("acos undefined above 1");
                }
                if (AsinOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("asin undefined above 1");
                }
                if (AtanOp$.MODULE$.equals(unaryOp)) {
                    decimal3 = Decimal$.MODULE$.Pi().$div(Decimal$.MODULE$.apply(2));
                } else if (NoOp$.MODULE$.equals(unaryOp)) {
                    decimal3 = Infinity$.MODULE$;
                } else {
                    throw new MatchError((Object)unaryOp);
                }
            }
            decimal = decimal3;
        } else if (NegInfinity$.MODULE$.$eq$eq(decimal2)) {
            Decimal decimal4;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                decimal4 = Decimal$.MODULE$.Zero();
            } else {
                if (LogOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("Cannot take the log of a negative number");
                }
                if (AbsOp$.MODULE$.equals(unaryOp)) {
                    decimal4 = Infinity$.MODULE$;
                } else {
                    if (SinOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("No limit for 'sin' at negative infinity");
                    }
                    if (CosOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("No limit for 'cos' at negative infinity");
                    }
                    if (TanOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("No limit for 'tan' at negative infinity");
                    }
                    if (AcosOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("acos undefined below -1");
                    }
                    if (AsinOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("asin undefined below -1");
                    }
                    if (AtanOp$.MODULE$.equals(unaryOp)) {
                        decimal4 = Decimal$.MODULE$.Pi().$div(Decimal$.MODULE$.apply(-2));
                    } else if (NoOp$.MODULE$.equals(unaryOp)) {
                        decimal4 = x;
                    } else {
                        throw new MatchError((Object)unaryOp);
                    }
                }
            }
            decimal = decimal4;
        } else if (Decimal$.MODULE$.Zero().$eq$eq(decimal2)) {
            Decimal decimal5;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.One();
            } else if (LogOp$.MODULE$.equals(unaryOp)) {
                decimal5 = NegInfinity$.MODULE$;
            } else if (AbsOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.Zero();
            } else if (SinOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.Zero();
            } else if (CosOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.One();
            } else if (TanOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.Zero();
            } else if (AsinOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.Zero();
            } else if (AcosOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.Pi().$div(Decimal$.MODULE$.apply(2));
            } else if (AtanOp$.MODULE$.equals(unaryOp)) {
                decimal5 = Decimal$.MODULE$.Zero();
            } else if (NoOp$.MODULE$.equals(unaryOp)) {
                decimal5 = x;
            } else {
                throw new MatchError((Object)unaryOp);
            }
            decimal = decimal5;
        } else {
            Decimal decimal6;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                decimal6 = Decimal$.MODULE$.apply(Math.exp(x.toDouble()));
            } else if (LogOp$.MODULE$.equals(unaryOp)) {
                if (x.toDouble() < 0.0) {
                    throw new ArithmeticException(new StringBuilder(23).append("Cannot take the log of ").append(x.toDouble()).toString());
                }
                decimal6 = Decimal$.MODULE$.apply(Math.log(x.toDouble()));
            } else if (AbsOp$.MODULE$.equals(unaryOp)) {
                decimal6 = this.abs(x);
            } else if (SinOp$.MODULE$.equals(unaryOp)) {
                decimal6 = Decimal$.MODULE$.apply(Math.sin(x.toDouble()));
            } else if (CosOp$.MODULE$.equals(unaryOp)) {
                decimal6 = Decimal$.MODULE$.apply(Math.cos(x.toDouble()));
            } else if (TanOp$.MODULE$.equals(unaryOp)) {
                decimal6 = Decimal$.MODULE$.apply(Math.tan(x.toDouble()));
            } else if (AsinOp$.MODULE$.equals(unaryOp)) {
                decimal6 = Decimal$.MODULE$.apply(Math.asin(x.toDouble()));
            } else if (AcosOp$.MODULE$.equals(unaryOp)) {
                decimal6 = Decimal$.MODULE$.apply(Math.acos(x.toDouble()));
            } else if (AtanOp$.MODULE$.equals(unaryOp)) {
                decimal6 = Decimal$.MODULE$.apply(Math.atan(x.toDouble()));
            } else if (NoOp$.MODULE$.equals(unaryOp)) {
                decimal6 = x;
            } else {
                throw new MatchError((Object)unaryOp);
            }
            decimal = decimal6;
        }
        return decimal;
    }

    public Decimal compare(Decimal a, Decimal b) {
        return a.$eq$eq(b) ? Decimal$.MODULE$.Zero() : (a.$greater(b) ? Decimal$.MODULE$.One() : Decimal$.MODULE$.apply(-1));
    }

    private double lcm(double x, double y) {
        return x * y / this.gcd(x, y);
    }

    private double gcd(double x, double y) {
        while (y != 0.0) {
            double d = y;
            y = x % y;
            x = d;
        }
        return RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x));
    }

    private DecimalOps$() {
    }
}

