/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.optimizer;

class LBFGS {
    private double stp1;
    private double ys;
    private double yy;
    private double yr;
    private int iter;
    private int point;
    private int ispt;
    private int iypt;
    private int bound;
    private int npt;
    private int inmc;
    private int info;
    private double stp;
    private int nfev;
    private double[] w;
    private int m;
    private int n;
    private double eps;
    private double[] diag;
    private double[] x;
    private static double gtol = 0.9;
    private static double STPMIN = 1.0E-20;
    private static double STPMAX = 1.0E20;
    private static double xtol = 1.0E-16;
    private static double ftol = 1.0E-4;
    private static int maxfev = 20;
    private static double p5 = 0.5;
    private static double p66 = 0.66;
    private static double xtrapf = 4.0;
    private double dg;
    private double dgm;
    private double dginit;
    private double dgtest;
    private double finit;
    private double ftest1;
    private double fm;
    private double stmin;
    private double stmax;
    private double width;
    private double width1;
    private boolean stage1 = false;
    private int infoc;
    private boolean brackt;
    private double[] dgx = new double[1];
    private double[] dgy = new double[1];
    private double[] fx = new double[1];
    private double[] fy = new double[1];
    private double[] dgxm = new double[1];
    private double[] dgym = new double[1];
    private double[] fxm = new double[1];
    private double[] fym = new double[1];
    private double stx;
    private double sty;

    public LBFGS(double[] dArray, int n, double d) {
        this.x = dArray;
        this.m = n;
        this.n = dArray.length;
        this.eps = d;
        this.w = new double[this.n * (2 * n + 1) + 2 * n];
        this.iter = 0;
        this.point = 0;
        this.diag = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.diag[i] = 1.0;
        }
        this.ispt = this.n + 2 * n;
        this.iypt = this.ispt + this.n * n;
    }

    public boolean apply(double d, double[] dArray) {
        double d2;
        boolean bl = false;
        if (this.iter == 0) {
            for (int i = 0; i < this.n; ++i) {
                this.w[this.ispt + i] = -dArray[i] * this.diag[i];
            }
            d2 = Math.sqrt(LBFGS.ddot(this.n, dArray, 0, 1, dArray, 0, 1));
            this.stp1 = 1.0 / d2;
            bl = true;
        }
        while (true) {
            double d3;
            if (bl) {
                ++this.iter;
                this.info = 0;
                this.bound = this.iter - 1;
                if (this.iter != 1) {
                    if (this.iter > this.m) {
                        this.bound = this.m;
                    }
                    this.ys = LBFGS.ddot(this.n, this.w, this.iypt + this.npt, 1, this.w, this.ispt + this.npt, 1);
                    this.yy = LBFGS.ddot(this.n, this.w, this.iypt + this.npt, 1, this.w, this.iypt + this.npt, 1);
                    for (int i = 0; i < this.n; ++i) {
                        this.diag[i] = this.ys / this.yy;
                    }
                }
            }
            if (bl) {
                if (this.iter != 1) {
                    int n;
                    int n2;
                    int n3 = this.point;
                    if (this.point == 0) {
                        n3 = this.m;
                    }
                    this.w[this.n + n3 - 1] = 1.0 / this.ys;
                    for (n2 = 0; n2 < this.n; ++n2) {
                        this.w[n2] = -dArray[n2];
                    }
                    n3 = this.point;
                    for (n2 = 0; n2 < this.bound; ++n2) {
                        if (--n3 == -1) {
                            n3 = this.m - 1;
                        }
                        d3 = LBFGS.ddot(this.n, this.w, this.ispt + n3 * this.n, 1, this.w, 0, 1);
                        this.inmc = this.n + this.m + n3;
                        n = this.iypt + n3 * this.n;
                        this.w[this.inmc] = this.w[this.n + n3] * d3;
                        LBFGS.daxpy(this.n, -this.w[this.inmc], this.w, n, 1, this.w, 0, 1);
                    }
                    for (n2 = 0; n2 < this.n; ++n2) {
                        this.w[n2] = this.diag[n2] * this.w[n2];
                    }
                    for (n2 = 0; n2 < this.bound; ++n2) {
                        this.yr = LBFGS.ddot(this.n, this.w, this.iypt + n3 * this.n, 1, this.w, 0, 1);
                        d3 = this.w[this.n + n3] * this.yr;
                        this.inmc = this.n + this.m + n3;
                        d3 = this.w[this.inmc] - d3;
                        n = this.ispt + n3 * this.n;
                        LBFGS.daxpy(this.n, d3, this.w, n, 1, this.w, 0, 1);
                        if (++n3 != this.m) continue;
                        n3 = 0;
                    }
                    for (n2 = 0; n2 < this.n; ++n2) {
                        this.w[this.ispt + this.point * this.n + n2] = this.w[n2];
                    }
                }
                this.nfev = 0;
                this.stp = 1.0;
                if (this.iter == 1) {
                    this.stp = this.stp1;
                }
                for (int i = 0; i < this.n; ++i) {
                    this.w[i] = dArray[i];
                }
            }
            this.mcsrch(d, dArray);
            if (this.info == -1) {
                return false;
            }
            this.npt = this.point * this.n;
            for (int i = 0; i < this.n; ++i) {
                this.w[this.ispt + this.npt + i] = this.stp * this.w[this.ispt + this.npt + i];
                this.w[this.iypt + this.npt + i] = dArray[i] - this.w[i];
            }
            ++this.point;
            if (this.point == this.m) {
                this.point = 0;
            }
            d2 = Math.sqrt(LBFGS.ddot(this.n, dArray, 0, 1, dArray, 0, 1));
            d3 = Math.sqrt(LBFGS.ddot(this.n, this.x, 0, 1, this.x, 0, 1));
            if (d2 / (d3 = Math.max(1.0, d3)) <= this.eps) {
                return true;
            }
            bl = true;
        }
    }

    private void mcsrch(double d, double[] dArray) {
        int n;
        int n2 = this.ispt + this.point * this.n;
        if (this.info != -1) {
            this.infoc = 1;
            this.dginit = 0.0;
            for (n = 0; n < this.n; ++n) {
                this.dginit += dArray[n] * this.w[n2 + n];
            }
            if (this.dginit >= 0.0) {
                throw new RuntimeException("dginit");
            }
            this.brackt = false;
            this.stage1 = true;
            this.nfev = 0;
            this.finit = d;
            this.dgtest = ftol * this.dginit;
            this.width = STPMAX - STPMIN;
            this.width1 = this.width / p5;
            for (n = 0; n < this.n; ++n) {
                this.diag[n] = this.x[n];
            }
            this.stx = 0.0;
            this.fx[0] = this.finit;
            this.dgx[0] = this.dginit;
            this.sty = 0.0;
            this.fy[0] = this.finit;
            this.dgy[0] = this.dginit;
        }
        while (true) {
            if (this.info != -1) {
                if (this.brackt) {
                    this.stmin = Math.min(this.stx, this.sty);
                    this.stmax = Math.max(this.stx, this.sty);
                } else {
                    this.stmin = this.stx;
                    this.stmax = this.stp + xtrapf * (this.stp - this.stx);
                }
                this.stp = Math.max(this.stp, STPMIN);
                this.stp = Math.min(this.stp, STPMAX);
                if (this.brackt && (this.stp <= this.stmin || this.stp >= this.stmax) || this.nfev >= maxfev - 1 || this.infoc == 0 || this.brackt && this.stmax - this.stmin <= xtol * this.stmax) {
                    this.stp = this.stx;
                }
                for (n = 0; n < this.n; ++n) {
                    this.x[n] = this.diag[n] + this.stp * this.w[n2 + n];
                }
                this.info = -1;
                return;
            }
            this.info = 0;
            ++this.nfev;
            this.dg = 0.0;
            for (n = 0; n < this.n; ++n) {
                this.dg += dArray[n] * this.w[n2 + n];
            }
            this.ftest1 = this.finit + this.stp * this.dgtest;
            if (this.brackt && (this.stp <= this.stmin || this.stp >= this.stmax) || this.infoc == 0) {
                this.info = 6;
            }
            if (this.stp == STPMAX && d <= this.ftest1 && this.dg <= this.dgtest) {
                this.info = 5;
            }
            if (this.stp == STPMIN && (d > this.ftest1 || this.dg >= this.dgtest)) {
                this.info = 4;
            }
            if (this.nfev >= maxfev) {
                this.info = 3;
            }
            if (this.brackt && this.stmax - this.stmin <= xtol * this.stmax) {
                this.info = 2;
            }
            if (d <= this.ftest1 && Math.abs(this.dg) <= gtol * -this.dginit) {
                this.info = 1;
            }
            if (this.info != 0) {
                return;
            }
            if (this.stage1 && d <= this.ftest1 && this.dg >= Math.min(ftol, gtol) * this.dginit) {
                this.stage1 = false;
            }
            if (this.stage1 && d <= this.fx[0] && d > this.ftest1) {
                this.fm = d - this.stp * this.dgtest;
                this.fxm[0] = this.fx[0] - this.stx * this.dgtest;
                this.fym[0] = this.fy[0] - this.sty * this.dgtest;
                this.dgm = this.dg - this.dgtest;
                this.dgxm[0] = this.dgx[0] - this.dgtest;
                this.dgym[0] = this.dgy[0] - this.dgtest;
                this.mcstep(this.fxm, this.dgxm, this.fym, this.dgym, this.fm, this.dgm);
                this.fx[0] = this.fxm[0] + this.stx * this.dgtest;
                this.fy[0] = this.fym[0] + this.sty * this.dgtest;
                this.dgx[0] = this.dgxm[0] + this.dgtest;
                this.dgy[0] = this.dgym[0] + this.dgtest;
            } else {
                this.mcstep(this.fx, this.dgx, this.fy, this.dgy, d, this.dg);
            }
            if (!this.brackt) continue;
            if (Math.abs(this.sty - this.stx) >= p66 * this.width1) {
                this.stp = this.stx + p5 * (this.sty - this.stx);
            }
            this.width1 = this.width;
            this.width = Math.abs(this.sty - this.stx);
        }
    }

    private void mcstep(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double d2) {
        double d3;
        boolean bl;
        this.infoc = 0;
        if (this.brackt && (this.stp <= Math.min(this.stx, this.sty) || this.stp >= Math.max(this.stx, this.sty)) || dArray2[0] * (this.stp - this.stx) >= 0.0 || this.stmax < this.stmin) {
            return;
        }
        double d4 = d2 * (dArray2[0] / Math.abs(dArray2[0]));
        if (d > dArray[0]) {
            this.infoc = 1;
            bl = true;
            double d5 = 3.0 * (dArray[0] - d) / (this.stp - this.stx) + dArray2[0] + d2;
            double d6 = LBFGS.max3(Math.abs(d5), Math.abs(dArray2[0]), Math.abs(d2));
            double d7 = d6 * Math.sqrt(LBFGS.sqr(d5 / d6) - dArray2[0] / d6 * (d2 / d6));
            if (this.stp < this.stx) {
                d7 = -d7;
            }
            double d8 = d7 - dArray2[0] + d5;
            double d9 = d7 - dArray2[0] + d7 + d2;
            double d10 = d8 / d9;
            double d11 = this.stx + d10 * (this.stp - this.stx);
            double d12 = this.stx + dArray2[0] / ((dArray[0] - d) / (this.stp - this.stx) + dArray2[0]) / 2.0 * (this.stp - this.stx);
            d3 = Math.abs(d11 - this.stx) < Math.abs(d12 - this.stx) ? d11 : d11 + (d12 - d11) / 2.0;
            this.brackt = true;
        } else if (d4 < 0.0) {
            this.infoc = 2;
            bl = false;
            double d13 = 3.0 * (dArray[0] - d) / (this.stp - this.stx) + dArray2[0] + d2;
            double d14 = LBFGS.max3(Math.abs(d13), Math.abs(dArray2[0]), Math.abs(d2));
            double d15 = d14 * Math.sqrt(LBFGS.sqr(d13 / d14) - dArray2[0] / d14 * (d2 / d14));
            if (this.stp > this.stx) {
                d15 = -d15;
            }
            double d16 = d15 - d2 + d13;
            double d17 = d15 - d2 + d15 + dArray2[0];
            double d18 = d16 / d17;
            double d19 = this.stp + d18 * (this.stx - this.stp);
            double d20 = this.stp + d2 / (d2 - dArray2[0]) * (this.stx - this.stp);
            d3 = Math.abs(d19 - this.stp) > Math.abs(d20 - this.stp) ? d19 : d20;
            this.brackt = true;
        } else if (Math.abs(d2) < Math.abs(dArray2[0])) {
            double d21;
            double d22;
            double d23;
            this.infoc = 3;
            bl = true;
            double d24 = 3.0 * (dArray[0] - d) / (this.stp - this.stx) + dArray2[0] + d2;
            double d25 = LBFGS.max3(Math.abs(d24), Math.abs(dArray2[0]), Math.abs(d2));
            double d26 = d25 * Math.sqrt(Math.max(0.0, LBFGS.sqr(d24 / d25) - dArray2[0] / d25 * (d2 / d25)));
            if (this.stp > this.stx) {
                d26 = -d26;
            }
            double d27 = (d23 = (d22 = d26 - d2 + d24) / (d21 = d26 + (dArray2[0] - d2) + d26)) < 0.0 && d26 != 0.0 ? this.stp + d23 * (this.stx - this.stp) : (this.stp > this.stx ? this.stmax : this.stmin);
            double d28 = this.stp + d2 / (d2 - dArray2[0]) * (this.stx - this.stp);
            d3 = this.brackt ? (Math.abs(this.stp - d27) < Math.abs(this.stp - d28) ? d27 : d28) : (Math.abs(this.stp - d27) > Math.abs(this.stp - d28) ? d27 : d28);
        } else {
            this.infoc = 4;
            bl = false;
            if (this.brackt) {
                double d29;
                double d30 = 3.0 * (d - dArray3[0]) / (this.sty - this.stp) + dArray4[0] + d2;
                double d31 = LBFGS.max3(Math.abs(d30), Math.abs(dArray4[0]), Math.abs(d2));
                double d32 = d31 * Math.sqrt(LBFGS.sqr(d30 / d31) - dArray4[0] / d31 * (d2 / d31));
                if (this.stp > this.sty) {
                    d32 = -d32;
                }
                double d33 = d32 - d2 + d30;
                double d34 = d32 - d2 + d32 + dArray4[0];
                double d35 = d33 / d34;
                d3 = d29 = this.stp + d35 * (this.sty - this.stp);
            } else {
                d3 = this.stp > this.stx ? this.stmax : this.stmin;
            }
        }
        if (d > dArray[0]) {
            this.sty = this.stp;
            dArray3[0] = d;
            dArray4[0] = d2;
        } else {
            if (d4 < 0.0) {
                this.sty = this.stx;
                dArray3[0] = dArray[0];
                dArray4[0] = dArray2[0];
            }
            this.stx = this.stp;
            dArray[0] = d;
            dArray2[0] = d2;
        }
        d3 = Math.min(this.stmax, d3);
        this.stp = d3 = Math.max(this.stmin, d3);
        if (this.brackt && bl) {
            this.stp = this.sty > this.stx ? Math.min(this.stx + 0.66 * (this.sty - this.stx), this.stp) : Math.max(this.stx + 0.66 * (this.sty - this.stx), this.stp);
        }
    }

    public static void daxpy(int n, double d, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        if (n <= 0) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        if (n3 != 1 || n5 != 1) {
            int n8 = 1;
            int n9 = 1;
            if (n3 < 0) {
                n8 = (-n + 1) * n3 + 1;
            }
            if (n5 < 0) {
                n9 = (-n + 1) * n5 + 1;
            }
            for (int i = 1; i <= n; ++i) {
                dArray2[n4 + n9 - 1] = dArray2[n4 + n9 - 1] + d * dArray[n2 + n8 - 1];
                n8 += n3;
                n9 += n5;
            }
            return;
        }
        int n10 = n % 4;
        if (n10 != 0) {
            for (n7 = 1; n7 <= n10; ++n7) {
                dArray2[n4 + n7 - 1] = dArray2[n4 + n7 - 1] + d * dArray[n2 + n7 - 1];
            }
            if (n < 4) {
                return;
            }
        }
        for (n7 = n6 = n10 + 1; n7 <= n; n7 += 4) {
            dArray2[n4 + n7 - 1] = dArray2[n4 + n7 - 1] + d * dArray[n2 + n7 - 1];
            dArray2[n4 + n7 + 1 - 1] = dArray2[n4 + n7 + 1 - 1] + d * dArray[n2 + n7 + 1 - 1];
            dArray2[n4 + n7 + 2 - 1] = dArray2[n4 + n7 + 2 - 1] + d * dArray[n2 + n7 + 2 - 1];
            dArray2[n4 + n7 + 3 - 1] = dArray2[n4 + n7 + 3 - 1] + d * dArray[n2 + n7 + 3 - 1];
        }
    }

    public static double ddot(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        double d = 0.0;
        if (n <= 0) {
            return 0.0;
        }
        if (n3 != 1 || n5 != 1) {
            int n8 = 1;
            int n9 = 1;
            if (n3 < 0) {
                n8 = (-n + 1) * n3 + 1;
            }
            if (n5 < 0) {
                n9 = (-n + 1) * n5 + 1;
            }
            for (int i = 1; i <= n; ++i) {
                d += dArray[n2 + n8 - 1] * dArray2[n4 + n9 - 1];
                n8 += n3;
                n9 += n5;
            }
            return d;
        }
        int n10 = n % 5;
        if (n10 != 0) {
            for (n7 = 1; n7 <= n10; ++n7) {
                d += dArray[n2 + n7 - 1] * dArray2[n4 + n7 - 1];
            }
            if (n < 5) {
                return d;
            }
        }
        for (n7 = n6 = n10 + 1; n7 <= n; n7 += 5) {
            d = d + dArray[n2 + n7 - 1] * dArray2[n4 + n7 - 1] + dArray[n2 + n7 + 1 - 1] * dArray2[n4 + n7 + 1 - 1] + dArray[n2 + n7 + 2 - 1] * dArray2[n4 + n7 + 2 - 1] + dArray[n2 + n7 + 3 - 1] * dArray2[n4 + n7 + 3 - 1] + dArray[n2 + n7 + 4 - 1] * dArray2[n4 + n7 + 4 - 1];
        }
        return d;
    }

    static double sqr(double d) {
        return d * d;
    }

    static double max3(double d, double d2, double d3) {
        return d < d2 ? (d2 < d3 ? d3 : d2) : (d < d3 ? d3 : d);
    }
}

