/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.sampler;

import com.stripe.rainier.sampler.DenseMassMatrix;
import com.stripe.rainier.sampler.MassMatrix;
import com.stripe.rainier.sampler.MassMatrixEstimator;
import com.stripe.rainier.sampler.VarianceEstimator;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00193Aa\u0003\u0007\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0004)\u0001\t\u0007I\u0011A\u0015\t\r5\u0002\u0001\u0015!\u0003+\u0011\u001dq\u0003A1A\u0005\u0002=BaA\u000e\u0001!\u0002\u0013\u0001\u0004\"B\u001c\u0001\t\u0003A\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002!\u0001\t\u0003y\u0003\"B!\u0001\t\u0003\u0011%aE\"pm\u0006\u0014\u0018.\u00198dK\u0016\u001bH/[7bi>\u0014(BA\u0007\u000f\u0003\u001d\u0019\u0018-\u001c9mKJT!a\u0004\t\u0002\u000fI\f\u0017N\\5fe*\u0011\u0011CE\u0001\u0007gR\u0014\u0018\u000e]3\u000b\u0003M\t1aY8n\u0007\u0001\u00192\u0001\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDH\u0007\u0002\u0019%\u0011q\u0004\u0004\u0002\u0014\u001b\u0006\u001c8/T1ue&DXi\u001d;j[\u0006$xN]\u0001\u0005g&TX\r\u0005\u0002\u0018E%\u00111\u0005\u0007\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002'OA\u0011Q\u0004\u0001\u0005\u0006A\t\u0001\r!I\u0001\tm\u0006\u0014\u0018.\u00198dKV\t!\u0006\u0005\u0002\u001eW%\u0011A\u0006\u0004\u0002\u0012-\u0006\u0014\u0018.\u00198dK\u0016\u001bH/[7bi>\u0014\u0018!\u0003<be&\fgnY3!\u0003\r\u0019wN^\u000b\u0002aA\u0019q#M\u001a\n\u0005IB\"!B!se\u0006L\bCA\f5\u0013\t)\u0004D\u0001\u0004E_V\u0014G.Z\u0001\u0005G>4\b%A\u0003sKN,G\u000fF\u0001:!\t9\"(\u0003\u0002<1\t!QK\\5u\u0003\u0019)\b\u000fZ1uKR\u0011\u0011H\u0010\u0005\u0006\u007f!\u0001\r\u0001M\u0001\u0007g\u0006l\u0007\u000f\\3\u0002\u0015\r|g/\u0019:jC:\u001cW-\u0001\u0006nCN\u001cX*\u0019;sSb,\u0012a\u0011\t\u0003;\u0011K!!\u0012\u0007\u0003\u00155\u000b7o]'biJL\u0007\u0010")
public class CovarianceEstimator
implements MassMatrixEstimator {
    private final int size;
    private final VarianceEstimator variance;
    private final double[] cov;

    public VarianceEstimator variance() {
        return this.variance;
    }

    public double[] cov() {
        return this.cov;
    }

    @Override
    public void reset() {
        this.variance().reset();
        for (int i = 0; i < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(this.cov())); ++i) {
            this.cov()[i] = 0.0;
        }
    }

    @Override
    public void update(double[] sample) {
        this.variance().update(sample);
        int l = 0;
        for (int j = 0; j < this.size; ++j) {
            int k = 0;
            while (k < this.size) {
                int n = j * this.size + k;
                this.cov()[n] = this.cov()[n] + this.variance().newDiff()[j] * this.variance().oldDiff()[k];
                ++k;
                ++l;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public double[] covariance() {
        void var1_1;
        double[] elements = new double[ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(this.cov()))];
        double z = this.variance().samples() - 1;
        for (int i = 0; i < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(this.cov())); ++i) {
            elements[i] = this.cov()[i] / z;
        }
        return var1_1;
    }

    @Override
    public MassMatrix massMatrix() {
        return new DenseMassMatrix(this.covariance());
    }

    public CovarianceEstimator(int size) {
        this.size = size;
        this.variance = new VarianceEstimator(size);
        this.cov = (double[])Array$.MODULE$.fill(size * size, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double());
    }
}

