/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.sampler;

import com.stripe.rainier.sampler.DenseMassMatrix;
import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;

public final class DenseMassMatrix$
implements Serializable {
    public static final DenseMassMatrix$ MODULE$ = new DenseMassMatrix$();

    public void squareMultiply(double[] matrix, double[] vector, double[] out) {
        int n = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(out));
        for (int i = 0; i < n; ++i) {
            double y = 0.0;
            for (int j = 0; j < n; ++j) {
                y += vector[j] * matrix[i * n + j];
            }
            out[i] = y;
        }
    }

    private int triangleNumber(int k) {
        return k * (k + 1) / 2;
    }

    public void upperTriangularSolve(double[] packed, double[] vector, double[] out) {
        int i = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(vector)) - 1;
        int m = this.triangleNumber(i + 1) - 1;
        while (i >= 0) {
            int j = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(vector)) - 1;
            double dot = 0.0;
            while (j > i) {
                dot += out[j] * packed[m];
                --j;
                --m;
            }
            out[i] = (vector[i] - dot) / packed[m];
            --i;
            --m;
        }
    }

    public int matrixSize(double[] elements) {
        return (int)package$.MODULE$.floor(package$.MODULE$.sqrt((double)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(elements))));
    }

    public double[] choleskyUpperTriangular(double[] matrix) {
        int i;
        int n = this.matrixSize(matrix);
        double[] lower = new double[this.triangleNumber(n)];
        int l = 0;
        for (i = 0; i < n; ++i) {
            int k = 0;
            while (k <= i) {
                double d;
                double sum = 0.0;
                for (int j = 0; j < k; ++j) {
                    sum += lower[this.triangleNumber(i) + j] * lower[this.triangleNumber(k) + j];
                }
                double x = matrix[i * n + k] - sum;
                if (i == k) {
                    d = package$.MODULE$.sqrt(x);
                } else {
                    double diag = lower[this.triangleNumber(k + 1) - 1];
                    d = 1.0 / diag * x;
                }
                lower[l] = d;
                ++k;
                ++l;
            }
        }
        double[] upper = new double[ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(lower))];
        l = 0;
        for (i = 0; i < n; ++i) {
            int k = 0;
            while (k < n - i) {
                upper[l] = lower[this.triangleNumber(k + i) + i];
                ++k;
                ++l;
            }
        }
        return upper;
    }

    public DenseMassMatrix apply(double[] elements) {
        return new DenseMassMatrix(elements);
    }

    public Option<double[]> unapply(DenseMassMatrix x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.elements());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DenseMassMatrix$.class);
    }

    private DenseMassMatrix$() {
    }
}

