/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.sampler;

import com.stripe.rainier.sampler.DensityFunction;
import com.stripe.rainier.sampler.IdentityMassMatrix$;
import com.stripe.rainier.sampler.LeapFrog;
import com.stripe.rainier.sampler.Log$;
import com.stripe.rainier.sampler.MassMatrix;
import com.stripe.rainier.sampler.MassMatrixTuner;
import com.stripe.rainier.sampler.Progress;
import com.stripe.rainier.sampler.RNG;
import com.stripe.rainier.sampler.Sampler;
import com.stripe.rainier.sampler.SamplerConfig;
import com.stripe.rainier.sampler.Stats;
import com.stripe.rainier.sampler.StepSizeTuner;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Driver$ {
    public static final Driver$ MODULE$ = new Driver$();

    public Tuple3<List<double[]>, MassMatrix, Stats> sample(int chain, SamplerConfig config, DensityFunction density, Progress progress, RNG rng) {
        Sampler sampler = config.sampler();
        StepSizeTuner stepSizeTuner = config.stepSizeTuner();
        MassMatrixTuner massMatrixTuner = config.massMatrixTuner();
        LeapFrog lf = new LeapFrog(density, config.statsWindow());
        progress.start(chain);
        Log$.MODULE$.FINE().log("Starting warmup");
        double[] params = lf.initialize(IdentityMassMatrix$.MODULE$, rng);
        MassMatrix mass = this.warmup(chain, params, lf, sampler, stepSizeTuner, massMatrixTuner, config.warmupIterations(), progress, rng);
        lf.resetStats();
        Log$.MODULE$.FINE().log("Starting sampling");
        List<double[]> samples = this.collectSamples(chain, params, lf, sampler, stepSizeTuner.stepSize(), mass, config.iterations(), progress, rng);
        Log$.MODULE$.FINE().log("Finished sampling");
        progress.finish(chain, "Complete", lf.stats(), mass);
        return new Tuple3(samples, (Object)mass, (Object)lf.stats());
    }

    private MassMatrix warmup(int chain, double[] params, LeapFrog lf, Sampler sampler, StepSizeTuner stepSizeTuner, MassMatrixTuner massMatrixTuner, int iterations, Progress progress, RNG rng) {
        long nextOutputTime = System.nanoTime();
        sampler.initialize(params, lf, rng);
        double stepSize = stepSizeTuner.initialize(params, lf);
        MassMatrix mass = massMatrixTuner.initialize(lf, iterations);
        Log$.MODULE$.FINER().log("Initial step size %f", (Object)BoxesRunTime.boxToDouble((double)stepSize));
        double[] sample = new double[lf.nVars()];
        for (int i = 0; i < iterations; ++i) {
            BoxedUnit boxedUnit;
            double logAcceptProb = sampler.warmup(params, lf, stepSize, mass, rng);
            stepSize = stepSizeTuner.update(logAcceptProb);
            Log$.MODULE$.FINEST().log("Accept probability %f", (Object)BoxesRunTime.boxToDouble((double)Math.exp(logAcceptProb)));
            Log$.MODULE$.FINEST().log("Adapted step size %f", (Object)BoxesRunTime.boxToDouble((double)stepSize));
            lf.variables(params, sample);
            Option<MassMatrix> option = massMatrixTuner.update(sample);
            if (option instanceof Some) {
                MassMatrix m;
                Some some = (Some)option;
                mass = m = (MassMatrix)some.value();
                stepSize = stepSizeTuner.reset();
                boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            if (System.nanoTime() <= nextOutputTime) continue;
            progress.refresh(chain, "Warmup", lf.stats(), mass);
            nextOutputTime = System.nanoTime() + (long)(progress.outputEverySeconds() * 1.0E9);
        }
        return mass;
    }

    private List<double[]> collectSamples(int chain, double[] params, LeapFrog lf, Sampler sampler, double stepSize, MassMatrix mass, int iterations, Progress progress, RNG rng) {
        long nextOutputTime = System.nanoTime();
        ListBuffer buf = new ListBuffer();
        for (int i = 0; i < iterations; ++i) {
            sampler.run(params, lf, stepSize, mass, rng);
            double[] output = new double[lf.nVars()];
            lf.variables(params, output);
            buf.$plus$eq((Object)output);
            if (System.nanoTime() <= nextOutputTime) continue;
            progress.refresh(chain, "Sampling", lf.stats(), mass);
            nextOutputTime = System.nanoTime() + (long)(progress.outputEverySeconds() * 1.0E9);
        }
        return buf.toList();
    }

    private Driver$() {
    }
}

