/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.sampler;

import com.stripe.rainier.sampler.DiagonalMassMatrix;
import com.stripe.rainier.sampler.MassMatrix;
import com.stripe.rainier.sampler.MassMatrixEstimator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t4AAF\f\u0001A!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u00044\u0001\u0001\u0007I\u0011\u0001\u001b\t\u000fU\u0002\u0001\u0019!C\u0001m!1A\b\u0001Q!\n1Bq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0001?\u0011\u00199\u0005\u0001)A\u0005\u007f!9\u0001\n\u0001b\u0001\n\u0003q\u0004BB%\u0001A\u0003%q\bC\u0004K\u0001\t\u0007I\u0011\u0001 \t\r-\u0003\u0001\u0015!\u0003@\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u001d\u0011\u0006A1A\u0005\u0002yBaa\u0015\u0001!\u0002\u0013y\u0004\"\u0002(\u0001\t\u0003!\u0006\"\u0002,\u0001\t\u00039\u0006\"\u0002-\u0001\t\u0003I\u0006\"B/\u0001\t\u0013q&!\u0005,be&\fgnY3FgRLW.\u0019;pe*\u0011\u0001$G\u0001\bg\u0006l\u0007\u000f\\3s\u0015\tQ2$A\u0004sC&t\u0017.\u001a:\u000b\u0005qi\u0012AB:ue&\u0004XMC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!JS\"A\f\n\u0005):\"aE'bgNl\u0015\r\u001e:jq\u0016\u001bH/[7bi>\u0014\u0018\u0001B:ju\u0016\u0004\"AI\u0017\n\u00059\u001a#aA%oi\u00061A(\u001b8jiz\"\"!\r\u001a\u0011\u0005!\u0002\u0001\"B\u0016\u0003\u0001\u0004a\u0013aB:b[BdWm]\u000b\u0002Y\u0005Y1/Y7qY\u0016\u001cx\fJ3r)\t9$\b\u0005\u0002#q%\u0011\u0011h\t\u0002\u0005+:LG\u000fC\u0004<\t\u0005\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0013'\u0001\u0005tC6\u0004H.Z:!\u0003\u0011iW-\u00198\u0016\u0003}\u00022A\t!C\u0013\t\t5EA\u0003BeJ\f\u0017\u0010\u0005\u0002#\u0007&\u0011Ai\t\u0002\u0007\t>,(\r\\3\u0002\u000b5,\u0017M\u001c\u0011\u0002\u0007I\fw/\u0001\u0003sC^\u0004\u0013aB8mI\u0012KgMZ\u0001\t_2$G)\u001b4gA\u00059a.Z<ES\u001a4\u0017\u0001\u00038fo\u0012KgM\u001a\u0011\u0002\u000bI,7/\u001a;\u0015\u0003]\na!\u001e9eCR,GCA\u001cQ\u0011\u0015\tv\u00021\u0001@\u0003\u0019\u0019\u0018-\u001c9mK\u0006)!-\u001e42\t\u00061!-\u001e42\t\u0002\"\"aN+\t\u000bE\u0013\u0002\u0019\u0001\"\u0002\u0011Y\f'/[1oG\u0016$\u0012aP\u0001\u000b[\u0006\u001c8/T1ue&DX#\u0001.\u0011\u0005!Z\u0016B\u0001/\u0018\u0005)i\u0015m]:NCR\u0014\u0018\u000e_\u0001\u0005I&4g\rF\u00028?\u0002DQ!U\u000bA\u0002}BQ!Y\u000bA\u0002}\n1AY;g\u0001")
public class VarianceEstimator
implements MassMatrixEstimator {
    private final int size;
    private int samples;
    private final double[] mean;
    private final double[] raw;
    private final double[] oldDiff;
    private final double[] newDiff;
    private final double[] buf1D;

    public int samples() {
        return this.samples;
    }

    public void samples_$eq(int x$1) {
        this.samples = x$1;
    }

    public double[] mean() {
        return this.mean;
    }

    public double[] raw() {
        return this.raw;
    }

    public double[] oldDiff() {
        return this.oldDiff;
    }

    public double[] newDiff() {
        return this.newDiff;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            this.mean()[i] = 0.0;
            this.raw()[i] = 0.0;
        }
    }

    @Override
    public void update(double[] sample) {
        this.samples_$eq(this.samples() + 1);
        this.diff(sample, this.oldDiff());
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.mean()[n] = this.mean()[n] + this.oldDiff()[i] / (double)this.samples();
        }
        this.diff(sample, this.newDiff());
        for (int j = 0; j < this.size; ++j) {
            int n = j;
            this.raw()[n] = this.raw()[n] + this.oldDiff()[j] * this.newDiff()[j];
        }
    }

    public double[] buf1D() {
        return this.buf1D;
    }

    public void update(double sample) {
        this.buf1D()[0] = sample;
        this.update(this.buf1D());
    }

    /*
     * WARNING - void declaration
     */
    public double[] variance() {
        void var1_1;
        double[] elements = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            elements[i] = this.raw()[i] / (double)this.samples();
        }
        return var1_1;
    }

    @Override
    public MassMatrix massMatrix() {
        return new DiagonalMassMatrix(this.variance());
    }

    private void diff(double[] sample, double[] buf) {
        for (int i = 0; i < this.size; ++i) {
            buf[i] = sample[i] - this.mean()[i];
        }
    }

    public VarianceEstimator(int size) {
        this.size = size;
        this.samples = 0;
        this.mean = new double[size];
        this.raw = new double[size];
        this.oldDiff = new double[size];
        this.newDiff = new double[size];
        this.buf1D = new double[]{0.0};
    }
}

