/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import org.spongycastle.bcpg.S2K;
import org.spongycastle.util.io.Streams;

class SXprUtils {
    SXprUtils() {
    }

    private static int readLength(InputStream in, int ch) throws IOException {
        int len = ch - 48;
        while ((ch = in.read()) >= 0 && ch != 58) {
            len = len * 10 + ch - 48;
        }
        return len;
    }

    static String readString(InputStream in, int ch) throws IOException {
        int len = SXprUtils.readLength(in, ch);
        char[] chars = new char[len];
        for (int i = 0; i != chars.length; ++i) {
            chars[i] = (char)in.read();
        }
        return new String(chars);
    }

    static byte[] readBytes(InputStream in, int ch) throws IOException {
        int len = SXprUtils.readLength(in, ch);
        byte[] data = new byte[len];
        Streams.readFully((InputStream)in, (byte[])data);
        return data;
    }

    static S2K parseS2K(InputStream in) throws IOException {
        SXprUtils.skipOpenParenthesis(in);
        String alg = SXprUtils.readString(in, in.read());
        byte[] iv = SXprUtils.readBytes(in, in.read());
        final long iterationCount = Long.parseLong(SXprUtils.readString(in, in.read()));
        SXprUtils.skipCloseParenthesis(in);
        S2K s2k = new S2K(2, iv, (int)iterationCount){

            public long getIterationCount() {
                return iterationCount;
            }
        };
        return s2k;
    }

    static void skipOpenParenthesis(InputStream in) throws IOException {
        int ch = in.read();
        if (ch != 40) {
            throw new IOException("unknown character encountered");
        }
    }

    static void skipCloseParenthesis(InputStream in) throws IOException {
        int ch = in.read();
        if (ch != 41) {
            throw new IOException("unknown character encountered");
        }
    }
}

