/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.beans;

import com.madrobot.beans.FeatureDescriptor;
import com.madrobot.beans.IntrospectionException;
import com.madrobot.beans.MethodDescriptor;
import com.madrobot.lang.reflect.MethodUtils;
import java.lang.ref.Reference;
import java.lang.reflect.Method;

public class EventSetDescriptor
extends FeatureDescriptor {
    private MethodDescriptor addMethodDescriptor;
    private MethodDescriptor getMethodDescriptor;
    private boolean inDefaultEventSet = true;
    private MethodDescriptor[] listenerMethodDescriptors;
    private Reference listenerMethodsRef;
    private Reference listenerTypeRef;
    private MethodDescriptor removeMethodDescriptor;
    private boolean unicast;

    private static String getListenerClassName(Class cls) {
        String className = cls.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static Method getMethod(Class cls, String name, int args) throws IntrospectionException {
        if (name == null) {
            return null;
        }
        Method method = MethodUtils.findAccessibleMethodIncludeInterfaces(cls, name, args, null);
        if (method == null) {
            throw new IntrospectionException("Method not found: " + name + " on class " + cls.getName());
        }
        return method;
    }

    public EventSetDescriptor(Class<?> sourceClass, String eventSetName, Class<?> listenerType, String listenerMethodName) throws IntrospectionException {
        this(sourceClass, eventSetName, listenerType, new String[]{listenerMethodName}, "add" + EventSetDescriptor.getListenerClassName(listenerType), "remove" + EventSetDescriptor.getListenerClassName(listenerType), "get" + EventSetDescriptor.getListenerClassName(listenerType) + "s");
        String eventName = String.valueOf(EventSetDescriptor.capitalize(eventSetName)) + "Event";
        Method[] listenerMethods = this.getListenerMethods();
        if (listenerMethods.length > 0) {
            Class<?>[] args = listenerMethods[0].getParameterTypes();
            if (!"vetoableChange".equals(eventSetName) && !args[0].getName().endsWith(eventName)) {
                throw new IntrospectionException("Method \"" + listenerMethodName + "\" should have argument \"" + eventName + "\"");
            }
        }
    }

    public EventSetDescriptor(Class<?> sourceClass, String eventSetName, Class<?> listenerType, String[] listenerMethodNames, String addListenerMethodName, String removeListenerMethodName) throws IntrospectionException {
        this(sourceClass, eventSetName, listenerType, listenerMethodNames, addListenerMethodName, removeListenerMethodName, null);
    }

    public EventSetDescriptor(Class<?> sourceClass, String eventSetName, Class<?> listenerType, String[] listenerMethodNames, String addListenerMethodName, String removeListenerMethodName, String getListenerMethodName) throws IntrospectionException {
        if (sourceClass == null || eventSetName == null || listenerType == null) {
            throw new NullPointerException();
        }
        this.setName(eventSetName);
        this.setClass0(sourceClass);
        this.setListenerType(listenerType);
        Method[] listenerMethods = new Method[listenerMethodNames.length];
        int i = 0;
        while (i < listenerMethodNames.length) {
            if (listenerMethodNames[i] == null) {
                throw new NullPointerException();
            }
            listenerMethods[i] = EventSetDescriptor.getMethod(listenerType, listenerMethodNames[i], 1);
            ++i;
        }
        this.setListenerMethods(listenerMethods);
        this.setAddListenerMethod(EventSetDescriptor.getMethod(sourceClass, addListenerMethodName, 1));
        this.setRemoveListenerMethod(EventSetDescriptor.getMethod(sourceClass, removeListenerMethodName, 1));
        Method method = MethodUtils.findAccessibleMethodIncludeInterfaces(sourceClass, getListenerMethodName, 0, null);
        if (method != null) {
            this.setGetListenerMethod(method);
        }
    }

    EventSetDescriptor(EventSetDescriptor old) {
        super(old);
        if (old.listenerMethodDescriptors != null) {
            int len = old.listenerMethodDescriptors.length;
            this.listenerMethodDescriptors = new MethodDescriptor[len];
            int i = 0;
            while (i < len) {
                this.listenerMethodDescriptors[i] = new MethodDescriptor(old.listenerMethodDescriptors[i]);
                ++i;
            }
        }
        this.listenerTypeRef = old.listenerTypeRef;
        this.addMethodDescriptor = old.addMethodDescriptor;
        this.removeMethodDescriptor = old.removeMethodDescriptor;
        this.getMethodDescriptor = old.getMethodDescriptor;
        this.unicast = old.unicast;
        this.inDefaultEventSet = old.inDefaultEventSet;
    }

    EventSetDescriptor(EventSetDescriptor x, EventSetDescriptor y) {
        super(x, y);
        this.listenerMethodDescriptors = x.listenerMethodDescriptors;
        if (y.listenerMethodDescriptors != null) {
            this.listenerMethodDescriptors = y.listenerMethodDescriptors;
        }
        this.listenerTypeRef = x.listenerTypeRef;
        if (y.listenerTypeRef != null) {
            this.listenerTypeRef = y.listenerTypeRef;
        }
        this.addMethodDescriptor = x.addMethodDescriptor;
        if (y.addMethodDescriptor != null) {
            this.addMethodDescriptor = y.addMethodDescriptor;
        }
        this.removeMethodDescriptor = x.removeMethodDescriptor;
        if (y.removeMethodDescriptor != null) {
            this.removeMethodDescriptor = y.removeMethodDescriptor;
        }
        this.getMethodDescriptor = x.getMethodDescriptor;
        if (y.getMethodDescriptor != null) {
            this.getMethodDescriptor = y.getMethodDescriptor;
        }
        this.unicast = y.unicast;
        if (!x.inDefaultEventSet || !y.inDefaultEventSet) {
            this.inDefaultEventSet = false;
        }
    }

    public EventSetDescriptor(String eventSetName, Class<?> listenerType, Method[] listenerMethods, Method addListenerMethod, Method removeListenerMethod) throws IntrospectionException {
        this(eventSetName, listenerType, listenerMethods, addListenerMethod, removeListenerMethod, null);
    }

    public EventSetDescriptor(String eventSetName, Class<?> listenerType, Method[] listenerMethods, Method addListenerMethod, Method removeListenerMethod, Method getListenerMethod) throws IntrospectionException {
        this.setName(eventSetName);
        this.setListenerMethods(listenerMethods);
        this.setAddListenerMethod(addListenerMethod);
        this.setRemoveListenerMethod(removeListenerMethod);
        this.setGetListenerMethod(getListenerMethod);
        this.setListenerType(listenerType);
    }

    public EventSetDescriptor(String eventSetName, Class<?> listenerType, MethodDescriptor[] listenerMethodDescriptors, Method addListenerMethod, Method removeListenerMethod) throws IntrospectionException {
        this.setName(eventSetName);
        this.listenerMethodDescriptors = listenerMethodDescriptors;
        this.setAddListenerMethod(addListenerMethod);
        this.setRemoveListenerMethod(removeListenerMethod);
        this.setListenerType(listenerType);
    }

    public synchronized Method getAddListenerMethod() {
        return this.addMethodDescriptor != null ? this.addMethodDescriptor.getMethod() : null;
    }

    public synchronized Method getGetListenerMethod() {
        return this.getMethodDescriptor != null ? this.getMethodDescriptor.getMethod() : null;
    }

    public synchronized MethodDescriptor[] getListenerMethodDescriptors() {
        return this.listenerMethodDescriptors;
    }

    public synchronized Method[] getListenerMethods() {
        Method[] methods = this.getListenerMethods0();
        if (methods == null) {
            if (this.listenerMethodDescriptors != null) {
                methods = new Method[this.listenerMethodDescriptors.length];
                int i = 0;
                while (i < methods.length) {
                    methods[i] = this.listenerMethodDescriptors[i].getMethod();
                    ++i;
                }
            }
            this.setListenerMethods(methods);
        }
        return methods;
    }

    private Method[] getListenerMethods0() {
        return (Method[])EventSetDescriptor.getObject(this.listenerMethodsRef);
    }

    public Class<?> getListenerType() {
        return (Class)EventSetDescriptor.getObject(this.listenerTypeRef);
    }

    public synchronized Method getRemoveListenerMethod() {
        return this.removeMethodDescriptor != null ? this.removeMethodDescriptor.getMethod() : null;
    }

    public boolean isInDefaultEventSet() {
        return this.inDefaultEventSet;
    }

    public boolean isUnicast() {
        return this.unicast;
    }

    private synchronized void setAddListenerMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.addMethodDescriptor = new MethodDescriptor(method);
    }

    private synchronized void setGetListenerMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.getMethodDescriptor = new MethodDescriptor(method);
    }

    public void setInDefaultEventSet(boolean inDefaultEventSet) {
        this.inDefaultEventSet = inDefaultEventSet;
    }

    private void setListenerMethods(Method[] methods) {
        if (methods == null) {
            return;
        }
        if (this.listenerMethodDescriptors == null) {
            this.listenerMethodDescriptors = new MethodDescriptor[methods.length];
            int i = 0;
            while (i < methods.length) {
                this.listenerMethodDescriptors[i] = new MethodDescriptor(methods[i]);
                ++i;
            }
        }
        this.listenerMethodsRef = EventSetDescriptor.createReference(methods, true);
    }

    private void setListenerType(Class cls) {
        this.listenerTypeRef = EventSetDescriptor.createReference(cls);
    }

    private synchronized void setRemoveListenerMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.removeMethodDescriptor = new MethodDescriptor(method);
    }

    public void setUnicast(boolean unicast) {
        this.unicast = unicast;
    }
}

