/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.beans;

import com.madrobot.beans.NameGenerator;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;

public class FeatureDescriptor {
    private Reference classRef;
    private String displayName;
    private boolean expert;
    private boolean hidden;
    private String name;
    private boolean preferred;
    private String shortDescription;
    private Hashtable table;

    static String capitalize(String s) {
        return NameGenerator.capitalize(s);
    }

    static Reference createReference(Object obj) {
        return FeatureDescriptor.createReference(obj, false);
    }

    static Reference createReference(Object obj, boolean soft) {
        Reference ref = null;
        if (obj != null) {
            ref = soft ? new SoftReference<Object>(obj) : new WeakReference<Object>(obj);
        }
        return ref;
    }

    static Object getObject(Reference ref) {
        return ref == null ? null : ref.get();
    }

    public FeatureDescriptor() {
    }

    FeatureDescriptor(FeatureDescriptor old) {
        this.expert = old.expert;
        this.hidden = old.hidden;
        this.preferred = old.preferred;
        this.name = old.name;
        this.shortDescription = old.shortDescription;
        this.displayName = old.displayName;
        this.classRef = old.classRef;
        this.addTable(old.table);
    }

    FeatureDescriptor(FeatureDescriptor x, FeatureDescriptor y) {
        this.expert = x.expert | y.expert;
        this.hidden = x.hidden | y.hidden;
        this.preferred = x.preferred | y.preferred;
        this.name = y.name;
        this.shortDescription = x.shortDescription;
        if (y.shortDescription != null) {
            this.shortDescription = y.shortDescription;
        }
        this.displayName = x.displayName;
        if (y.displayName != null) {
            this.displayName = y.displayName;
        }
        this.classRef = x.classRef;
        if (y.classRef != null) {
            this.classRef = y.classRef;
        }
        this.addTable(x.table);
        this.addTable(y.table);
    }

    private void addTable(Hashtable t) {
        if (t == null) {
            return;
        }
        Enumeration keys = t.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = t.get(key);
            this.setValue(key, value);
        }
    }

    public Enumeration<String> attributeNames() {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        return this.table.keys();
    }

    Class getClass0() {
        return (Class)FeatureDescriptor.getObject(this.classRef);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return this.getDisplayName();
        }
        return this.shortDescription;
    }

    public Object getValue(String attributeName) {
        if (this.table == null) {
            return null;
        }
        return this.table.get(attributeName);
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    void setClass0(Class cls) {
        this.classRef = FeatureDescriptor.createReference(cls);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    public void setShortDescription(String text) {
        this.shortDescription = text;
    }

    public void setValue(String attributeName, Object value) {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        this.table.put(attributeName, value);
    }
}

