/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.beans;

import com.madrobot.beans.BeanDescriptor;
import com.madrobot.beans.BeanInfo;
import com.madrobot.beans.EventSetDescriptor;
import com.madrobot.beans.IndexedPropertyDescriptor;
import com.madrobot.beans.MethodDescriptor;
import com.madrobot.beans.PropertyDescriptor;
import com.madrobot.beans.SimpleBeanInfo;

class GenericBeanInfo
extends SimpleBeanInfo {
    private BeanDescriptor beanDescriptor;
    private int defaultEvent;
    private int defaultProperty;
    private EventSetDescriptor[] events;
    private MethodDescriptor[] methods;
    private PropertyDescriptor[] properties;
    private BeanInfo targetBeanInfo;

    public GenericBeanInfo(BeanDescriptor beanDescriptor, EventSetDescriptor[] events, int defaultEvent, PropertyDescriptor[] properties, int defaultProperty, MethodDescriptor[] methods, BeanInfo targetBeanInfo) {
        this.beanDescriptor = beanDescriptor;
        this.events = events;
        this.defaultEvent = defaultEvent;
        this.properties = properties;
        this.defaultProperty = defaultProperty;
        this.methods = methods;
        this.targetBeanInfo = targetBeanInfo;
    }

    GenericBeanInfo(GenericBeanInfo old) {
        int i;
        int len;
        this.beanDescriptor = new BeanDescriptor(old.beanDescriptor);
        if (old.events != null) {
            len = old.events.length;
            this.events = new EventSetDescriptor[len];
            i = 0;
            while (i < len) {
                this.events[i] = new EventSetDescriptor(old.events[i]);
                ++i;
            }
        }
        this.defaultEvent = old.defaultEvent;
        if (old.properties != null) {
            len = old.properties.length;
            this.properties = new PropertyDescriptor[len];
            i = 0;
            while (i < len) {
                PropertyDescriptor oldp = old.properties[i];
                this.properties[i] = oldp instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor((IndexedPropertyDescriptor)oldp) : new PropertyDescriptor(oldp);
                ++i;
            }
        }
        this.defaultProperty = old.defaultProperty;
        if (old.methods != null) {
            len = old.methods.length;
            this.methods = new MethodDescriptor[len];
            i = 0;
            while (i < len) {
                this.methods[i] = new MethodDescriptor(old.methods[i]);
                ++i;
            }
        }
        this.targetBeanInfo = old.targetBeanInfo;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public int getDefaultEventIndex() {
        return this.defaultEvent;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.defaultProperty;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.events;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.methods;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties;
    }
}

