/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.beans;

import com.madrobot.beans.BeanDescriptor;
import com.madrobot.beans.BeanInfo;
import com.madrobot.beans.EventSetDescriptor;
import com.madrobot.beans.FeatureDescriptor;
import com.madrobot.beans.GenericBeanInfo;
import com.madrobot.beans.IndexedPropertyDescriptor;
import com.madrobot.beans.IntrospectionException;
import com.madrobot.beans.MethodDescriptor;
import com.madrobot.beans.PropertyDescriptor;
import com.madrobot.beans.PropertyVetoException;
import com.madrobot.lang.reflect.ClassUtils;
import com.madrobot.lang.reflect.MethodUtils;
import com.madrobot.text.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class Introspector {
    private static final String ADD_PREFIX = "add";
    private static final String BEANINFO_SUFFIX = "BeanInfo";
    private static Map<Class<?>, BeanInfo> beanInfoCache = Collections.synchronizedMap(new WeakHashMap());
    private static final String DEFAULT_INFO_PATH = "sun.beans.infos";
    private static final EventSetDescriptor[] EMPTY_EVENTSETDESCRIPTORS = new EventSetDescriptor[0];
    private static Class eventListenerType = EventListener.class;
    private static final String GET_PREFIX = "get";
    public static final int IGNORE_ALL_BEANINFO = 3;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    private static final String IS_PREFIX = "is";
    private static final String REMOVE_PREFIX = "remove";
    private static String[] searchPath = new String[]{"sun.beans.infos"};
    private static final String SET_PREFIX = "set";
    public static final int USE_ALL_BEANINFO = 1;
    private BeanInfo[] additionalBeanInfo;
    private Class beanClass;
    private int defaultEventIndex = -1;
    private String defaultEventName;
    private int defaultPropertyIndex = -1;
    private String defaultPropertyName;
    private Map events;
    private BeanInfo explicitBeanInfo;
    private Map methods;
    private HashMap pdStore = new HashMap();
    private Map properties;
    private boolean propertyChangeSource = false;
    private BeanInfo superBeanInfo;

    /*
     * Unable to fully structure code
     */
    private static synchronized BeanInfo findExplicitBeanInfo(Class beanClass) {
        name = String.valueOf(beanClass.getName()) + "BeanInfo";
        try {
            return (BeanInfo)ClassUtils.instantiate(beanClass, name);
        }
        catch (Exception var2_2) {
            try {
                if (ClassUtils.isSubclass(beanClass, BeanInfo.class)) {
                    return (BeanInfo)beanClass.newInstance();
                }
            }
            catch (Exception var2_3) {
                // empty catch block
            }
            name = name.substring(name.lastIndexOf(46) + 1);
            i = 0;
            ** while (i < Introspector.searchPath.length)
        }
lbl-1000:
        // 1 sources

        {
            if (!"sun.beans.infos".equals(Introspector.searchPath[i]) || "sun.beans.infos".equals(Introspector.searchPath[i]) && "ComponentBeanInfo".equals(name)) {
                try {
                    fullName = String.valueOf(Introspector.searchPath[i]) + "." + name;
                    bi = (BeanInfo)ClassUtils.instantiate(beanClass, fullName);
                    if (bi.getBeanDescriptor() != null) {
                        if (bi.getBeanDescriptor().getBeanClass() == beanClass) {
                            return bi;
                        }
                    } else if (bi.getPropertyDescriptors() != null) {
                        pds = bi.getPropertyDescriptors();
                        j = 0;
                        while (j < pds.length) {
                            method = pds[j].getReadMethod();
                            if (method == null) {
                                method = pds[j].getWriteMethod();
                            }
                            if (method != null && method.getDeclaringClass() == beanClass) {
                                return bi;
                            }
                            ++j;
                        }
                    } else if (bi.getMethodDescriptors() != null) {
                        mds = bi.getMethodDescriptors();
                        j = 0;
                        while (j < mds.length) {
                            method = mds[j].getMethod();
                            if (method != null && method.getDeclaringClass() == beanClass) {
                                return bi;
                            }
                            ++j;
                        }
                    }
                }
                catch (Exception var3_7) {
                    // empty catch block
                }
            }
            ++i;
            continue;
        }
lbl48:
        // 1 sources

        return null;
    }

    public static void flushCaches() {
        beanInfoCache.clear();
    }

    public static void flushFromCaches(Class<?> clz) {
        if (clz == null) {
            throw new NullPointerException();
        }
        beanInfoCache.remove(clz);
    }

    private static BeanInfo getBeanInfo(Class beanClass, Class stopClass, int flags) throws IntrospectionException {
        BeanInfo bi = stopClass == null && flags == 1 ? Introspector.getBeanInfo(beanClass) : new Introspector(beanClass, stopClass, flags).getBeanInfo();
        return bi;
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        BeanInfo bi = beanInfoCache.get(beanClass);
        if (bi == null) {
            bi = new Introspector(beanClass, null, 1).getBeanInfo();
            beanInfoCache.put(beanClass, bi);
        }
        return bi;
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(beanClass, stopClass, 1);
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, int flags) throws IntrospectionException {
        return Introspector.getBeanInfo(beanClass, null, flags);
    }

    public static synchronized String[] getBeanInfoSearchPath() {
        String[] result = new String[searchPath.length];
        int i = 0;
        while (i < searchPath.length) {
            result[i] = searchPath[i];
            ++i;
        }
        return result;
    }

    private static String makeQualifiedMethodName(String name, String[] params) {
        StringBuffer sb = new StringBuffer(name);
        sb.append('=');
        int i = 0;
        while (i < params.length) {
            sb.append(':');
            sb.append(params[i]);
            ++i;
        }
        return sb.toString();
    }

    public static synchronized void setBeanInfoSearchPath(String[] path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        searchPath = path;
    }

    private Introspector(Class beanClass, Class stopClass, int flags) throws IntrospectionException {
        Class superClass;
        this.beanClass = beanClass;
        if (stopClass != null) {
            boolean isSuper = false;
            Class c = beanClass.getSuperclass();
            while (c != null) {
                if (c == stopClass) {
                    isSuper = true;
                }
                c = c.getSuperclass();
            }
            if (!isSuper) {
                throw new IntrospectionException(String.valueOf(stopClass.getName()) + " not superclass of " + beanClass.getName());
            }
        }
        if (flags == 1) {
            this.explicitBeanInfo = Introspector.findExplicitBeanInfo(beanClass);
        }
        if ((superClass = beanClass.getSuperclass()) != stopClass) {
            int newFlags = flags;
            if (newFlags == 2) {
                newFlags = 1;
            }
            this.superBeanInfo = Introspector.getBeanInfo(superClass, stopClass, newFlags);
        }
        if (this.explicitBeanInfo != null) {
            this.additionalBeanInfo = this.explicitBeanInfo.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private void addEvent(EventSetDescriptor esd) {
        EventSetDescriptor old;
        String key = esd.getName();
        if (esd.getName().equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if ((old = (EventSetDescriptor)this.events.get(key)) == null) {
            this.events.put(key, esd);
            return;
        }
        EventSetDescriptor composite = new EventSetDescriptor(old, esd);
        this.events.put(key, composite);
    }

    private void addMethod(MethodDescriptor md) {
        String name = md.getName();
        MethodDescriptor old = (MethodDescriptor)this.methods.get(name);
        if (old == null) {
            this.methods.put(name, md);
            return;
        }
        String[] p1 = md.getParamNames();
        String[] p2 = old.getParamNames();
        boolean match = false;
        if (p1.length == p2.length) {
            match = true;
            int i = 0;
            while (i < p1.length) {
                if (p1[i] != p2[i]) {
                    match = false;
                    break;
                }
                ++i;
            }
        }
        if (match) {
            MethodDescriptor composite = new MethodDescriptor(old, md);
            this.methods.put(name, composite);
            return;
        }
        String longKey = Introspector.makeQualifiedMethodName(name, p1);
        old = (MethodDescriptor)this.methods.get(longKey);
        if (old == null) {
            this.methods.put(longKey, md);
            return;
        }
        MethodDescriptor composite = new MethodDescriptor(old, md);
        this.methods.put(longKey, composite);
    }

    private void addPropertyDescriptor(PropertyDescriptor pd) {
        String propName = pd.getName();
        ArrayList<PropertyDescriptor> list = (ArrayList<PropertyDescriptor>)this.pdStore.get(propName);
        if (list == null) {
            list = new ArrayList<PropertyDescriptor>();
            this.pdStore.put(propName, list);
        }
        list.add(pd);
    }

    private BeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor bd = this.getTargetBeanDescriptor();
        MethodDescriptor[] mds = this.getTargetMethodInfo();
        EventSetDescriptor[] esds = this.getTargetEventInfo();
        PropertyDescriptor[] pds = this.getTargetPropertyInfo();
        int defaultEvent = this.getTargetDefaultEventIndex();
        int defaultProperty = this.getTargetDefaultPropertyIndex();
        return new GenericBeanInfo(bd, esds, defaultEvent, pds, defaultProperty, mds, this.explicitBeanInfo);
    }

    private BeanDescriptor getTargetBeanDescriptor() {
        BeanDescriptor bd;
        if (this.explicitBeanInfo != null && (bd = this.explicitBeanInfo.getBeanDescriptor()) != null) {
            return bd;
        }
        return new BeanDescriptor(this.beanClass);
    }

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        EventSetDescriptor[] result;
        if (this.events == null) {
            this.events = new HashMap();
        }
        EventSetDescriptor[] explicitEvents = null;
        if (this.explicitBeanInfo != null) {
            explicitEvents = this.explicitBeanInfo.getEventSetDescriptors();
            int ix = this.explicitBeanInfo.getDefaultEventIndex();
            if (ix >= 0 && ix < explicitEvents.length) {
                this.defaultEventName = explicitEvents[ix].getName();
            }
        }
        if (explicitEvents == null && this.superBeanInfo != null) {
            EventSetDescriptor[] supers = this.superBeanInfo.getEventSetDescriptors();
            int i = 0;
            while (i < supers.length) {
                this.addEvent(supers[i]);
                ++i;
            }
            int ix = this.superBeanInfo.getDefaultEventIndex();
            if (ix >= 0 && ix < supers.length) {
                this.defaultEventName = supers[ix].getName();
            }
        }
        int i = 0;
        while (i < this.additionalBeanInfo.length) {
            EventSetDescriptor[] additional = this.additionalBeanInfo[i].getEventSetDescriptors();
            if (additional != null) {
                int j = 0;
                while (j < additional.length) {
                    this.addEvent(additional[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (explicitEvents != null) {
            i = 0;
            while (i < explicitEvents.length) {
                this.addEvent(explicitEvents[i]);
                ++i;
            }
        } else {
            Method[] methodList = MethodUtils.getPublicDeclaredMethods(this.beanClass);
            HashMap<String, Method> adds = null;
            HashMap<String, Method> removes = null;
            HashMap<String, Method> gets = null;
            int i2 = 0;
            while (i2 < methodList.length) {
                String name;
                int mods;
                Method method = methodList[i2];
                if (method != null && !Modifier.isStatic(mods = method.getModifiers()) && ((name = method.getName()).startsWith(ADD_PREFIX) || name.startsWith(REMOVE_PREFIX) || name.startsWith(GET_PREFIX))) {
                    String listenerName;
                    Class<?>[] argTypes = method.getParameterTypes();
                    Class<?> resultType = method.getReturnType();
                    if (name.startsWith(ADD_PREFIX) && argTypes.length == 1 && resultType == Void.TYPE && ClassUtils.isSubclass(argTypes[0], eventListenerType)) {
                        listenerName = name.substring(3);
                        if (listenerName.length() > 0 && argTypes[0].getName().endsWith(listenerName)) {
                            if (adds == null) {
                                adds = new HashMap<String, Method>();
                            }
                            adds.put(listenerName, method);
                        }
                    } else if (name.startsWith(REMOVE_PREFIX) && argTypes.length == 1 && resultType == Void.TYPE && ClassUtils.isSubclass(argTypes[0], eventListenerType)) {
                        listenerName = name.substring(6);
                        if (listenerName.length() > 0 && argTypes[0].getName().endsWith(listenerName)) {
                            if (removes == null) {
                                removes = new HashMap<String, Method>();
                            }
                            removes.put(listenerName, method);
                        }
                    } else if (name.startsWith(GET_PREFIX) && argTypes.length == 0 && resultType.isArray() && ClassUtils.isSubclass(resultType.getComponentType(), eventListenerType) && (listenerName = name.substring(3, name.length() - 1)).length() > 0 && resultType.getComponentType().getName().endsWith(listenerName)) {
                        if (gets == null) {
                            gets = new HashMap<String, Method>();
                        }
                        gets.put(listenerName, method);
                    }
                }
                ++i2;
            }
            if (adds != null && removes != null) {
                for (String listenerName : adds.keySet()) {
                    if (removes.get(listenerName) == null || !listenerName.endsWith("Listener")) continue;
                    String eventName = StringUtils.simpleUncapitalize(listenerName.substring(0, listenerName.length() - 8));
                    Method addMethod = (Method)adds.get(listenerName);
                    Method removeMethod = (Method)removes.get(listenerName);
                    Method getMethod = null;
                    if (gets != null) {
                        getMethod = (Method)gets.get(listenerName);
                    }
                    Class<?> argType = addMethod.getParameterTypes()[0];
                    Method[] allMethods = MethodUtils.getPublicDeclaredMethods(argType);
                    ArrayList<Method> validMethods = new ArrayList<Method>(allMethods.length);
                    int i3 = 0;
                    while (i3 < allMethods.length) {
                        if (allMethods[i3] != null && this.isEventHandler(allMethods[i3])) {
                            validMethods.add(allMethods[i3]);
                        }
                        ++i3;
                    }
                    Method[] methods = validMethods.toArray(new Method[validMethods.size()]);
                    EventSetDescriptor esd = new EventSetDescriptor(eventName, argType, methods, addMethod, removeMethod, getMethod);
                    if (MethodUtils.throwsException(addMethod, TooManyListenersException.class)) {
                        esd.setUnicast(true);
                    }
                    this.addEvent(esd);
                }
            }
        }
        if (this.events.size() == 0) {
            result = EMPTY_EVENTSETDESCRIPTORS;
        } else {
            result = new EventSetDescriptor[this.events.size()];
            result = this.events.values().toArray(result);
            if (this.defaultEventName != null) {
                int i4 = 0;
                while (i4 < result.length) {
                    if (this.defaultEventName.equals(result[i4].getName())) {
                        this.defaultEventIndex = i4;
                    }
                    ++i4;
                }
            }
        }
        return result;
    }

    private MethodDescriptor[] getTargetMethodInfo() {
        if (this.methods == null) {
            this.methods = new HashMap(100);
        }
        MethodDescriptor[] explicitMethods = null;
        if (this.explicitBeanInfo != null) {
            explicitMethods = this.explicitBeanInfo.getMethodDescriptors();
        }
        if (explicitMethods == null && this.superBeanInfo != null) {
            MethodDescriptor[] supers = this.superBeanInfo.getMethodDescriptors();
            int i = 0;
            while (i < supers.length) {
                this.addMethod(supers[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < this.additionalBeanInfo.length) {
            MethodDescriptor[] additional = this.additionalBeanInfo[i].getMethodDescriptors();
            if (additional != null) {
                int j = 0;
                while (j < additional.length) {
                    this.addMethod(additional[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (explicitMethods != null) {
            i = 0;
            while (i < explicitMethods.length) {
                this.addMethod(explicitMethods[i]);
                ++i;
            }
        } else {
            Method[] methodList = MethodUtils.getPublicDeclaredMethods(this.beanClass);
            int i2 = 0;
            while (i2 < methodList.length) {
                Method method = methodList[i2];
                if (method != null) {
                    MethodDescriptor md = new MethodDescriptor(method);
                    this.addMethod(md);
                }
                ++i2;
            }
        }
        MethodDescriptor[] result = new MethodDescriptor[this.methods.size()];
        result = this.methods.values().toArray(result);
        return result;
    }

    private PropertyDescriptor[] getTargetPropertyInfo() {
        PropertyDescriptor[] explicitProperties = null;
        if (this.explicitBeanInfo != null) {
            explicitProperties = this.explicitBeanInfo.getPropertyDescriptors();
            int ix = this.explicitBeanInfo.getDefaultPropertyIndex();
            if (ix >= 0 && ix < explicitProperties.length) {
                this.defaultPropertyName = explicitProperties[ix].getName();
            }
        }
        if (explicitProperties == null && this.superBeanInfo != null) {
            PropertyDescriptor[] supers = this.superBeanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < supers.length) {
                this.addPropertyDescriptor(supers[i]);
                ++i;
            }
            int ix = this.superBeanInfo.getDefaultPropertyIndex();
            if (ix >= 0 && ix < supers.length) {
                this.defaultPropertyName = supers[ix].getName();
            }
        }
        int i = 0;
        while (i < this.additionalBeanInfo.length) {
            PropertyDescriptor[] additional = this.additionalBeanInfo[i].getPropertyDescriptors();
            if (additional != null) {
                int j = 0;
                while (j < additional.length) {
                    this.addPropertyDescriptor(additional[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (explicitProperties != null) {
            i = 0;
            while (i < explicitProperties.length) {
                this.addPropertyDescriptor(explicitProperties[i]);
                ++i;
            }
        } else {
            Method[] methodList = MethodUtils.getPublicDeclaredMethods(this.beanClass);
            int i2 = 0;
            while (i2 < methodList.length) {
                int mods;
                Method method = methodList[i2];
                if (method != null && !Modifier.isStatic(mods = method.getModifiers())) {
                    String name = method.getName();
                    Class<?>[] argTypes = method.getParameterTypes();
                    Class<?> resultType = method.getReturnType();
                    int argCount = argTypes.length;
                    PropertyDescriptor pd = null;
                    if (name.length() > 3 || name.startsWith(IS_PREFIX)) {
                        try {
                            if (argCount == 0) {
                                if (name.startsWith(GET_PREFIX)) {
                                    pd = new PropertyDescriptor(StringUtils.simpleUncapitalize(name.substring(3)), method, null);
                                } else if (resultType == Boolean.TYPE && name.startsWith(IS_PREFIX)) {
                                    pd = new PropertyDescriptor(StringUtils.simpleUncapitalize(name.substring(2)), method, null);
                                }
                            } else if (argCount == 1) {
                                if (argTypes[0] == Integer.TYPE && name.startsWith(GET_PREFIX)) {
                                    pd = new IndexedPropertyDescriptor(StringUtils.simpleUncapitalize(name.substring(3)), null, null, method, null);
                                } else if (resultType == Void.TYPE && name.startsWith(SET_PREFIX)) {
                                    pd = new PropertyDescriptor(StringUtils.simpleUncapitalize(name.substring(3)), null, method);
                                    if (MethodUtils.throwsException(method, PropertyVetoException.class)) {
                                        pd.setConstrained(true);
                                    }
                                }
                            } else if (argCount == 2 && argTypes[0] == Integer.TYPE && name.startsWith(SET_PREFIX)) {
                                pd = new IndexedPropertyDescriptor(StringUtils.simpleUncapitalize(name.substring(3)), null, null, null, method);
                                if (MethodUtils.throwsException(method, PropertyVetoException.class)) {
                                    pd.setConstrained(true);
                                }
                            }
                        }
                        catch (IntrospectionException ex) {
                            pd = null;
                        }
                        if (pd != null) {
                            if (this.propertyChangeSource) {
                                pd.setBound(true);
                            }
                            this.addPropertyDescriptor(pd);
                        }
                    }
                }
                ++i2;
            }
        }
        this.processPropertyDescriptors();
        PropertyDescriptor[] result = new PropertyDescriptor[this.properties.size()];
        result = this.properties.values().toArray(result);
        if (this.defaultPropertyName != null) {
            int i3 = 0;
            while (i3 < result.length) {
                if (this.defaultPropertyName.equals(result[i3].getName())) {
                    this.defaultPropertyIndex = i3;
                }
                ++i3;
            }
        }
        return result;
    }

    private boolean isEventHandler(Method m) {
        Class<?>[] argTypes = m.getParameterTypes();
        if (argTypes.length != 1) {
            return false;
        }
        return ClassUtils.isSubclass(argTypes[0], EventObject.class);
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor ipd1, IndexedPropertyDescriptor ipd2) {
        if (ipd1.getClass0().isAssignableFrom(ipd2.getClass0())) {
            return new IndexedPropertyDescriptor(ipd1, ipd2);
        }
        return new IndexedPropertyDescriptor(ipd2, ipd1);
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor ipd, PropertyDescriptor pd) {
        PropertyDescriptor result = null;
        Class<?> propType = pd.getPropertyType();
        Class<?> ipropType = ipd.getIndexedPropertyType();
        if (propType.isArray() && propType.getComponentType() == ipropType) {
            result = pd.getClass0().isAssignableFrom(ipd.getClass0()) ? new IndexedPropertyDescriptor(pd, ipd) : new IndexedPropertyDescriptor(ipd, pd);
        } else if (pd.getClass0().isAssignableFrom(ipd.getClass0())) {
            result = ipd;
        } else {
            result = pd;
            Method write = result.getWriteMethod();
            Method read = result.getReadMethod();
            if (read == null && write != null && (read = MethodUtils.findAccessibleMethodIncludeInterfaces(result.getClass0(), GET_PREFIX + FeatureDescriptor.capitalize(result.getName()), 0, null)) != null) {
                try {
                    result.setReadMethod(read);
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
            if (write == null && read != null && (write = MethodUtils.findAccessibleMethodIncludeInterfaces(result.getClass0(), SET_PREFIX + FeatureDescriptor.capitalize(result.getName()), 1, new Class[]{read.getReturnType()})) != null) {
                try {
                    result.setWriteMethod(write);
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private PropertyDescriptor mergePropertyDescriptor(PropertyDescriptor pd1, PropertyDescriptor pd2) {
        if (pd1.getClass0().isAssignableFrom(pd2.getClass0())) {
            return new PropertyDescriptor(pd1, pd2);
        }
        return new PropertyDescriptor(pd2, pd1);
    }

    private void processPropertyDescriptors() {
        if (this.properties == null) {
            this.properties = new TreeMap();
        }
        Iterator it = this.pdStore.values().iterator();
        while (it.hasNext()) {
            PropertyDescriptor pd = null;
            PropertyDescriptor gpd = null;
            PropertyDescriptor spd = null;
            IndexedPropertyDescriptor ipd = null;
            IndexedPropertyDescriptor igpd = null;
            IndexedPropertyDescriptor ispd = null;
            List list = (List)it.next();
            int i = 0;
            while (i < list.size()) {
                pd = (PropertyDescriptor)list.get(i);
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                    if (ipd.getIndexedReadMethod() != null) {
                        igpd = igpd != null ? new IndexedPropertyDescriptor(igpd, ipd) : ipd;
                    }
                } else if (pd.getReadMethod() != null) {
                    if (gpd != null) {
                        Method method = gpd.getReadMethod();
                        if (!method.getName().startsWith(IS_PREFIX)) {
                            gpd = new PropertyDescriptor(gpd, pd);
                        }
                    } else {
                        gpd = pd;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < list.size()) {
                pd = (PropertyDescriptor)list.get(i);
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                    if (ipd.getIndexedWriteMethod() != null) {
                        if (igpd != null) {
                            if (igpd.getIndexedPropertyType() == ipd.getIndexedPropertyType()) {
                                ispd = ispd != null ? new IndexedPropertyDescriptor(ispd, ipd) : ipd;
                            }
                        } else {
                            ispd = ispd != null ? new IndexedPropertyDescriptor(ispd, ipd) : ipd;
                        }
                    }
                } else if (pd.getWriteMethod() != null) {
                    if (gpd != null) {
                        if (gpd.getPropertyType() == pd.getPropertyType()) {
                            spd = spd != null ? new PropertyDescriptor(spd, pd) : pd;
                        }
                    } else {
                        spd = spd != null ? new PropertyDescriptor(spd, pd) : pd;
                    }
                }
                ++i;
            }
            pd = null;
            ipd = null;
            if (igpd != null && ispd != null) {
                PropertyDescriptor tpd;
                if (gpd != null && (tpd = this.mergePropertyDescriptor(igpd, gpd)) instanceof IndexedPropertyDescriptor) {
                    igpd = (IndexedPropertyDescriptor)tpd;
                }
                if (spd != null && (tpd = this.mergePropertyDescriptor(ispd, spd)) instanceof IndexedPropertyDescriptor) {
                    ispd = (IndexedPropertyDescriptor)tpd;
                }
                pd = igpd == ispd ? igpd : this.mergePropertyDescriptor(igpd, ispd);
            } else if (gpd != null && spd != null) {
                pd = gpd == spd ? gpd : this.mergePropertyDescriptor(gpd, spd);
            } else if (ispd != null) {
                pd = ispd;
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(ispd, spd);
                }
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(ispd, gpd);
                }
            } else if (igpd != null) {
                pd = igpd;
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(igpd, gpd);
                }
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(igpd, spd);
                }
            } else if (spd != null) {
                pd = spd;
            } else if (gpd != null) {
                pd = gpd;
            }
            if (pd instanceof IndexedPropertyDescriptor && (ipd = (IndexedPropertyDescriptor)pd).getIndexedReadMethod() == null && ipd.getIndexedWriteMethod() == null) {
                pd = new PropertyDescriptor(ipd);
            }
            if (pd == null) continue;
            this.properties.put(pd.getName(), pd);
        }
    }
}

