/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.beans;

import com.madrobot.beans.FeatureDescriptor;
import com.madrobot.beans.ParameterDescriptor;
import com.madrobot.lang.reflect.MethodUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodDescriptor
extends FeatureDescriptor {
    private Reference methodRef;
    private ParameterDescriptor[] parameterDescriptors;
    private String[] paramNames;
    private List params;

    public MethodDescriptor(Method method) {
        this(method, null);
    }

    public MethodDescriptor(Method method, ParameterDescriptor[] parameterDescriptors) {
        this.setName(method.getName());
        this.setMethod(method);
        this.parameterDescriptors = parameterDescriptors;
    }

    MethodDescriptor(MethodDescriptor old) {
        super(old);
        this.methodRef = old.methodRef;
        this.params = old.params;
        this.paramNames = old.paramNames;
        if (old.parameterDescriptors != null) {
            int len = old.parameterDescriptors.length;
            this.parameterDescriptors = new ParameterDescriptor[len];
            int i = 0;
            while (i < len) {
                this.parameterDescriptors[i] = new ParameterDescriptor(old.parameterDescriptors[i]);
                ++i;
            }
        }
    }

    MethodDescriptor(MethodDescriptor x, MethodDescriptor y) {
        super(x, y);
        this.methodRef = x.methodRef;
        if (y.methodRef != null) {
            this.methodRef = y.methodRef;
        }
        this.params = x.params;
        if (y.params != null) {
            this.params = y.params;
        }
        this.paramNames = x.paramNames;
        if (y.paramNames != null) {
            this.paramNames = y.paramNames;
        }
        this.parameterDescriptors = x.parameterDescriptors;
        if (y.parameterDescriptors != null) {
            this.parameterDescriptors = y.parameterDescriptors;
        }
    }

    public synchronized Method getMethod() {
        Class cls;
        Method method = this.getMethod0();
        if (method == null && (cls = this.getClass0()) != null) {
            Class[] params = this.getParams();
            if (params == null) {
                int i = 0;
                while (i < 3) {
                    method = MethodUtils.findAccessibleMethodIncludeInterfaces(cls, this.getName(), i, null);
                    if (method == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                method = MethodUtils.findAccessibleMethodIncludeInterfaces(cls, this.getName(), params.length, params);
            }
            this.setMethod(method);
        }
        return method;
    }

    private Method getMethod0() {
        return (Method)MethodDescriptor.getObject(this.methodRef);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    String[] getParamNames() {
        return this.paramNames;
    }

    private synchronized Class[] getParams() {
        Class[] clss = new Class[this.params.size()];
        int i = 0;
        while (i < this.params.size()) {
            Reference ref = (Reference)this.params.get(i);
            Class cls = (Class)ref.get();
            if (cls == null) {
                return null;
            }
            clss[i] = cls;
            ++i;
        }
        return clss;
    }

    private synchronized void setMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.setParams(method.getParameterTypes());
        this.methodRef = MethodDescriptor.createReference(method, true);
    }

    private synchronized void setParams(Class[] param) {
        if (param == null) {
            return;
        }
        this.paramNames = new String[param.length];
        this.params = new ArrayList(param.length);
        int i = 0;
        while (i < param.length) {
            this.paramNames[i] = param[i].getName();
            this.params.add(new WeakReference<Class>(param[i]));
            ++i;
        }
    }
}

