/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.beans;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ObjectIdDictionary {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public void associateId(Object obj, Object id) {
        this.map.put(new WeakIdWrapper(obj), id);
        this.cleanup();
    }

    private void cleanup() {
        WeakIdWrapper wrapper;
        while ((wrapper = (WeakIdWrapper)this.queue.poll()) != null) {
            this.map.remove(wrapper);
        }
    }

    public boolean containsId(Object item) {
        boolean b = this.map.containsKey(new IdWrapper(item));
        return b;
    }

    public Object lookupId(Object obj) {
        Object id = this.map.get(new IdWrapper(obj));
        return id;
    }

    public void removeId(Object item) {
        this.map.remove(new IdWrapper(item));
        this.cleanup();
    }

    public int size() {
        this.cleanup();
        return this.map.size();
    }

    private static class IdWrapper
    implements Wrapper {
        private final int hashCode;
        private final Object obj;

        public IdWrapper(Object obj) {
            this.hashCode = System.identityHashCode(obj);
            this.obj = obj;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            return this.obj == ((Wrapper)other).get();
        }

        @Override
        public Object get() {
            return this.obj;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public String toString() {
            return this.obj.toString();
        }
    }

    private class WeakIdWrapper
    extends WeakReference
    implements Wrapper {
        private final int hashCode;

        public WeakIdWrapper(Object obj) {
            super(obj, ObjectIdDictionary.this.queue);
            this.hashCode = System.identityHashCode(obj);
        }

        @Override
        public boolean equals(Object other) {
            return this.get() == ((Wrapper)other).get();
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public String toString() {
            Object obj = this.get();
            return obj == null ? "(null)" : obj.toString();
        }
    }

    private static interface Wrapper {
        public boolean equals(Object var1);

        public Object get();

        public int hashCode();

        public String toString();
    }
}

