/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.lang;

import java.util.HashMap;
import java.util.Map;

public final class PrimitiveUtils {
    private static final Map BOX = new HashMap();
    private static final Map NAMED_PRIMITIVE = new HashMap();
    private static final Map REPRESENTING_CHAR = new HashMap();
    private static final Map UNBOX = new HashMap();

    static {
        Class[][] boxing = new Class[][]{{Byte.TYPE, Byte.class}, {Character.TYPE, Character.class}, {Short.TYPE, Short.class}, {Integer.TYPE, Integer.class}, {Long.TYPE, Long.class}, {Float.TYPE, Float.class}, {Double.TYPE, Double.class}, {Boolean.TYPE, Boolean.class}, {Void.TYPE, Void.class}};
        Character[] characterArray = new Character[9];
        characterArray[0] = new Character('B');
        characterArray[1] = new Character('C');
        characterArray[2] = new Character('S');
        characterArray[3] = new Character('I');
        characterArray[4] = new Character('J');
        characterArray[5] = new Character('F');
        characterArray[6] = new Character('D');
        characterArray[7] = new Character('Z');
        Character[] representingChars = characterArray;
        int i = 0;
        while (i < boxing.length) {
            Class primitiveType = boxing[i][0];
            Class boxedType = boxing[i][1];
            BOX.put(primitiveType, boxedType);
            UNBOX.put(boxedType, primitiveType);
            NAMED_PRIMITIVE.put(primitiveType.getName(), primitiveType);
            REPRESENTING_CHAR.put(primitiveType, representingChars[i]);
            ++i;
        }
    }

    public static Class box(Class type) {
        return (Class)BOX.get(type);
    }

    public static boolean isBoxed(Class type) {
        return UNBOX.containsKey(type);
    }

    public static Class primitiveType(String name) {
        return (Class)NAMED_PRIMITIVE.get(name);
    }

    public static char representingChar(Class type) {
        Character ch = (Character)REPRESENTING_CHAR.get(type);
        return ch == null ? (char)'\u0000' : ch.charValue();
    }

    private static byte[] toByta(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static byte[] toByteArray(double data) {
        return PrimitiveUtils.toByta(Double.doubleToRawLongBits(data));
    }

    public static double toDouble(byte[] data) {
        if (data == null || data.length != 8) {
            return 0.0;
        }
        return Double.longBitsToDouble(PrimitiveUtils.toLong(data));
    }

    private static long toLong(byte[] data) {
        if (data == null || data.length != 8) {
            return 0L;
        }
        return (long)(0xFF & data[0]) << 56 | (long)(0xFF & data[1]) << 48 | (long)(0xFF & data[2]) << 40 | (long)(0xFF & data[3]) << 32 | (long)(0xFF & data[4]) << 24 | (long)(0xFF & data[5]) << 16 | (long)(0xFF & data[6]) << 8 | (long)(0xFF & data[7]) << 0;
    }

    public static Class unbox(Class type) {
        return (Class)UNBOX.get(type);
    }
}

