/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.lang.reflect;

import com.madrobot.di.xml.converter.ObjectAccessException;
import com.madrobot.di.xml.core.TypedNull;
import com.madrobot.lang.ArrayUtils;
import com.madrobot.lang.PrimitiveUtils;
import com.madrobot.text.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ClassUtils {
    private static final Map<String, String> abbreviationMap = new HashMap<String, String>();
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR = String.valueOf('$');
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = String.valueOf('.');
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<String, String> reverseAbbreviationMap = new HashMap<String, String>();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap = new HashMap();

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        for (Class<?> primitiveClass : primitiveWrapperMap.keySet()) {
            Class<?> wrapperClass;
            if (primitiveClass.equals(wrapperClass = primitiveWrapperMap.get(primitiveClass))) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
        ClassUtils.addAbbreviation("int", "I");
        ClassUtils.addAbbreviation("boolean", "Z");
        ClassUtils.addAbbreviation("float", "F");
        ClassUtils.addAbbreviation("long", "J");
        ClassUtils.addAbbreviation("short", "S");
        ClassUtils.addAbbreviation("byte", "B");
        ClassUtils.addAbbreviation("double", "D");
        ClassUtils.addAbbreviation("char", "C");
    }

    private static void addAbbreviation(String primitive, String abbreviation) {
        abbreviationMap.put(primitive, abbreviation);
        reverseAbbreviationMap.put(abbreviation, primitive);
    }

    public static List<String> convertClassesToClassNames(List<Class<?>> classes) {
        if (classes == null) {
            return null;
        }
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        for (Class<?> cls : classes) {
            if (cls == null) {
                classNames.add(null);
                continue;
            }
            classNames.add(cls.getName());
        }
        return classNames;
    }

    public static List<Class<?>> convertClassNamesToClasses(List<String> classNames) {
        if (classNames == null) {
            return null;
        }
        ArrayList classes = new ArrayList(classNames.size());
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (Exception ex) {
                classes.add(null);
            }
        }
        return classes;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = cls.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                if (interfacesFound.add(i)) {
                    ClassUtils.getAllInterfaces(i, interfacesFound);
                }
                ++n2;
            }
            cls = cls.getSuperclass();
        }
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        Class<?> superclass = cls.getSuperclass();
        while (superclass != null) {
            classes.add(superclass);
            superclass = superclass.getSuperclass();
        }
        return classes;
    }

    private static String getCanonicalName(String className) {
        if ((className = StringUtils.deleteWhitespace(className)) == null) {
            return null;
        }
        int dim = 0;
        while (className.startsWith("[")) {
            ++dim;
            className = className.substring(1);
        }
        if (dim < 1) {
            return className;
        }
        if (className.startsWith("L")) {
            className = className.substring(1, className.endsWith(";") ? className.length() - 1 : className.length());
        } else if (className.length() > 0) {
            className = reverseAbbreviationMap.get(className.substring(0, 1));
        }
        StringBuilder canonicalClassNameBuffer = new StringBuilder(className);
        int i = 0;
        while (i < dim) {
            canonicalClassNameBuffer.append("[]");
            ++i;
        }
        return canonicalClassNameBuffer.toString();
    }

    public static Class<?> getClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return ClassUtils.getClass(classLoader, className, true);
    }

    public static Class<?> getClass(ClassLoader classLoader, String className, boolean initialize) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            if (abbreviationMap.containsKey(className)) {
                String clsName = "[" + abbreviationMap.get(className);
                clazz = Class.forName(clsName, initialize, classLoader).getComponentType();
            } else {
                clazz = Class.forName(ClassUtils.toCanonicalName(className), initialize, classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    return ClassUtils.getClass(classLoader, String.valueOf(className.substring(0, lastDotIndex)) + '$' + className.substring(lastDotIndex + 1), initialize);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClass(className, true);
    }

    public static Class<?> getClass(String className, boolean initialize) throws ClassNotFoundException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextCL == null ? ClassUtils.class.getClassLoader() : contextCL;
        return ClassUtils.getClass(loader, className, initialize);
    }

    public static String getPackageCanonicalName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtils.getPackageCanonicalName(cls.getName());
    }

    public static String getPackageCanonicalName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getPackageCanonicalName(object.getClass().getName());
    }

    public static String getPackageCanonicalName(String canonicalName) {
        return ClassUtils.getPackageName(ClassUtils.getCanonicalName(canonicalName));
    }

    public static String getPackageName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtils.getPackageName(cls.getName());
    }

    public static String getPackageName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getPackageName(object.getClass());
    }

    /*
     * Unable to fully structure code
     */
    public static String getPackageName(String className) {
        if (className != null && className.length() != 0) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            className = className.substring(1);
lbl4:
            // 2 sources

            ** while (className.charAt((int)0) == '[')
        }
lbl5:
        // 1 sources

        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            className = className.substring(1);
        }
        if ((i = className.lastIndexOf(46)) == -1) {
            return "";
        }
        return className.substring(0, i);
    }

    public static Method getPublicMethod(Class<?> cls, String methodName, Class<?>[] parameterTypes) throws SecurityException, NoSuchMethodException {
        Method declaredMethod = cls.getMethod(methodName, parameterTypes);
        if (Modifier.isPublic(declaredMethod.getDeclaringClass().getModifiers())) {
            return declaredMethod;
        }
        ArrayList candidateClasses = new ArrayList();
        candidateClasses.addAll(ClassUtils.getAllInterfaces(cls));
        candidateClasses.addAll(ClassUtils.getAllSuperclasses(cls));
        for (Class clazz : candidateClasses) {
            Method candidateMethod;
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                candidateMethod = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
            if (!Modifier.isPublic(candidateMethod.getDeclaringClass().getModifiers())) continue;
            return candidateMethod;
        }
        throw new NoSuchMethodException("Can't find a public method for " + methodName + " " + ArrayUtils.toString(parameterTypes));
    }

    public static String getShortCanonicalName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortCanonicalName(cls.getName());
    }

    public static String getShortCanonicalName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getShortCanonicalName(object.getClass().getName());
    }

    public static String getShortCanonicalName(String canonicalName) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(canonicalName));
    }

    public static String getShortClassName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortClassName(cls.getName());
    }

    public static String getShortClassName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getShortClassName(object.getClass());
    }

    public static String getShortClassName(String className) {
        int lastDotIdx;
        if (className == null) {
            return "";
        }
        if (className.length() == 0) {
            return "";
        }
        StringBuilder arrayPrefix = new StringBuilder();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1);
            }
        }
        if (reverseAbbreviationMap.containsKey(className)) {
            className = reverseAbbreviationMap.get(className);
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring(lastDotIdx + 1);
        if (innerIdx != -1) {
            out = out.replace('$', '.');
        }
        return String.valueOf(out) + arrayPrefix;
    }

    public static Object instantiate(Class sibling, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception cls) {
                // empty catch block
            }
        }
        try {
            cl = ClassLoader.getSystemClassLoader();
            if (cl != null) {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
        }
        catch (Exception cls) {
            // empty catch block
        }
        cl = Thread.currentThread().getContextClassLoader();
        Class<?> cls = cl.loadClass(className);
        return cls.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T instantiateUsingSerialization(final Class<T> type) {
        try {
            WeakHashMap<Class<T>, byte[]> serializedDataCache;
            WeakHashMap<Class<T>, byte[]> weakHashMap = serializedDataCache = new WeakHashMap<Class<T>, byte[]>();
            synchronized (weakHashMap) {
                byte[] data = (byte[])serializedDataCache.get(type);
                if (data == null) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    DataOutputStream stream = new DataOutputStream(bytes);
                    stream.writeShort(-21267);
                    stream.writeShort(5);
                    stream.writeByte(115);
                    stream.writeByte(114);
                    stream.writeUTF(type.getName());
                    stream.writeLong(ObjectStreamClass.lookup(type).getSerialVersionUID());
                    stream.writeByte(2);
                    stream.writeShort(0);
                    stream.writeByte(120);
                    stream.writeByte(112);
                    data = bytes.toByteArray();
                    serializedDataCache.put(type, data);
                }
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data)){

                    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        return Class.forName(desc.getName(), false, type.getClassLoader());
                    }
                };
                return (T)in.readObject();
            }
        }
        catch (IOException e) {
            throw new ObjectAccessException("Cannot create " + type.getName() + " by JDK serialization", e);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectAccessException("Cannot find class " + e.getMessage(), e);
        }
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        return ClassUtils.isAssignable(cls, toClass, true);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ClassUtils.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray) {
        return ClassUtils.isAssignable(classArray, toClassArray, true);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray, boolean autoboxing) {
        if (!ArrayUtils.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = new Class[]{};
        }
        if (toClassArray == null) {
            toClassArray = new Class[]{};
        }
        int i = 0;
        while (i < classArray.length) {
            if (!ClassUtils.isAssignable(classArray[i], toClassArray[i], autoboxing)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInnerClass(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return cls.getName().indexOf(36) >= 0;
    }

    public static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class x = a;
        while (x != null) {
            if (x == b) {
                return true;
            }
            if (b.isInterface()) {
                Class<?>[] interfaces = x.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (ClassUtils.isSubclass(interfaces[i], b)) {
                        return true;
                    }
                    ++i;
                }
            }
            x = x.getSuperclass();
        }
        return false;
    }

    public static Object newInstance(Class type, Object[] dependencies) {
        return ClassUtils.newInstance(type, dependencies, new BitSet());
    }

    /*
     * Unable to fully structure code
     */
    public static Object newInstance(Class type, Object[] dependencies, BitSet usedDependencies) {
        block30: {
            bestMatchingCtor = null;
            matchingDependencies = new ArrayList<Object>();
            if (dependencies == null || dependencies.length <= 0) break block30;
            ctors = type.getConstructors();
            if (ctors.length > 1) {
                Arrays.sort(ctors, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((Constructor)o2).getParameterTypes().length - ((Constructor)o1).getParameterTypes().length;
                    }
                });
            }
            typedDependencies = new TypedValue[dependencies.length];
            i = 0;
            while (i < dependencies.length) {
                dependency = dependencies[i];
                depType = dependency.getClass();
                if (depType.isPrimitive()) {
                    depType = PrimitiveUtils.box(depType);
                } else if (depType == TypedNull.class) {
                    depType = ((TypedNull)dependency).getType();
                    dependency = null;
                }
                typedDependencies[i] = new TypedValue(depType, dependency);
                ++i;
            }
            possibleCtor = null;
            arity = 0x7FFFFFFF;
            i = 0;
            while (bestMatchingCtor == null && i < ctors.length) {
                block31: {
                    constructor = ctors[i];
                    parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length > dependencies.length) break block31;
                    if (parameterTypes.length == 0) {
                        if (possibleCtor != null) break;
                        bestMatchingCtor = constructor;
                        break;
                    }
                    if (arity <= parameterTypes.length) ** GOTO lbl37
                    if (possibleCtor != null) {
                        bestMatchingCtor = possibleCtor;
                    } else {
                        arity = parameterTypes.length;
lbl37:
                        // 2 sources

                        j = 0;
                        while (j < parameterTypes.length) {
                            if (parameterTypes[j].isPrimitive()) {
                                parameterTypes[j] = PrimitiveUtils.box(parameterTypes[j]);
                            }
                            ++j;
                        }
                        matchingDependencies.clear();
                        j = usedDependencies.length();
                        while (j-- > 0) {
                            usedDependencies.clear(j);
                        }
                        j = 0;
                        k = 0;
                        while (j < parameterTypes.length && parameterTypes.length + k - j <= typedDependencies.length) {
                            if (parameterTypes[j].isAssignableFrom(typedDependencies[k].type)) {
                                matchingDependencies.add(typedDependencies[k].value);
                                usedDependencies.set(k);
                                if (++j == parameterTypes.length) {
                                    bestMatchingCtor = constructor;
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (bestMatchingCtor == null && possibleCtor == null) {
                            possibleCtor = constructor;
                            deps = new TypedValue[typedDependencies.length];
                            System.arraycopy(typedDependencies, 0, deps, 0, deps.length);
                            matchingDependencies.clear();
                            j = usedDependencies.length();
                            while (j-- > 0) {
                                usedDependencies.clear(j);
                            }
                            j = 0;
                            while (j < parameterTypes.length) {
                                assignable = -1;
                                k = 0;
                                while (k < deps.length) {
                                    if (deps[k] != null) {
                                        if (deps[k].type == parameterTypes[j]) {
                                            assignable = k;
                                            break;
                                        }
                                        if (parameterTypes[j].isAssignableFrom(deps[k].type) && (assignable < 0 || deps[assignable].type != deps[k].type && deps[assignable].type.isAssignableFrom(deps[k].type))) {
                                            assignable = k;
                                        }
                                    }
                                    ++k;
                                }
                                if (assignable < 0) {
                                    possibleCtor = null;
                                    break;
                                }
                                matchingDependencies.add(deps[assignable].value);
                                usedDependencies.set(assignable);
                                deps[assignable] = null;
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
            if (bestMatchingCtor == null) {
                if (possibleCtor == null) {
                    j = usedDependencies.length();
                    while (j-- > 0) {
                        usedDependencies.clear(j);
                    }
                    throw new ObjectAccessException("Cannot construct " + type.getName() + ", none of the dependencies match any constructor's parameters");
                }
                bestMatchingCtor = possibleCtor;
            }
        }
        try {
            instance = bestMatchingCtor == null ? type.newInstance() : bestMatchingCtor.newInstance(matchingDependencies.toArray());
            return instance;
        }
        catch (InstantiationException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            Constructor<?>[] constructors = type.getDeclaredConstructors();
            int i = 0;
            while (i < constructors.length) {
                Constructor<?> constructor = constructors[i];
                if (constructor.getParameterTypes().length == 0) {
                    if (!constructor.isAccessible()) {
                        constructor.setAccessible(true);
                    }
                    return (T)constructor.newInstance(new Object[0]);
                }
                ++i;
            }
            if (Serializable.class.isAssignableFrom(type)) {
                return ClassUtils.instantiateUsingSerialization(type);
            }
            throw new ObjectAccessException("Cannot construct " + type.getName() + " as it does not have a no-args constructor");
        }
        catch (InstantiationException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new ObjectAccessException("Constructor for " + type.getName() + " threw an exception", e.getTargetException());
        }
    }

    public static Class<?>[] primitivesToWrappers(Class<?>[] classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        int i = 0;
        while (i < classes.length) {
            convertedClasses[i] = ClassUtils.primitiveToWrapper(classes[i]);
            ++i;
        }
        return convertedClasses;
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    private static String toCanonicalName(String className) {
        if ((className = StringUtils.deleteWhitespace(className)) == null) {
            throw new NullPointerException("className must not be null.");
        }
        if (className.endsWith("[]")) {
            StringBuilder classNameBuffer = new StringBuilder();
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(className);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append("L").append(className).append(";");
            }
            className = classNameBuffer.toString();
        }
        return className;
    }

    public static Class<?>[] toClass(Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Class[0];
        }
        Class[] classes = new Class[array.length];
        int i = 0;
        while (i < array.length) {
            classes[i] = array[i] == null ? null : array[i].getClass();
            ++i;
        }
        return classes;
    }

    public static Class<?>[] wrappersToPrimitives(Class<?>[] classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        int i = 0;
        while (i < classes.length) {
            convertedClasses[i] = ClassUtils.wrapperToPrimitive(classes[i]);
            ++i;
        }
        return convertedClasses;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    private ClassUtils() {
    }

    private static class TypedValue {
        final Class type;
        final Object value;

        public TypedValue(Class type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.type.getName()) + ":" + this.value;
        }
    }
}

