/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.lang.reflect;

import com.madrobot.lang.reflect.ClassUtils;
import com.madrobot.lang.reflect.MemberUtils;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class MethodUtils {
    private static Map declaredMethodCache = Collections.synchronizedMap(new WeakHashMap());

    /*
     * Unable to fully structure code
     */
    public static Method findAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            method = cls.getMethod(methodName, parameterTypes);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException method) {
            bestMatch = null;
            methods = cls.getMethods();
            i = 0;
            size = methods.length;
            ** while (i < size)
        }
lbl-1000:
        // 1 sources

        {
            if (methods[i].getName().equals(methodName) && ClassUtils.isAssignable(parameterTypes, methods[i].getParameterTypes(), true) && (accessibleMethod = MethodUtils.getAccessibleMethod(methods[i])) != null && (bestMatch == null || MemberUtils.compareParameterTypes(accessibleMethod.getParameterTypes(), bestMatch.getParameterTypes(), parameterTypes) < 0)) {
                bestMatch = accessibleMethod;
            }
            ++i;
            continue;
        }
lbl15:
        // 1 sources

        if (bestMatch != null) {
            MemberUtils.setAccessibleWorkaround(bestMatch);
        }
        return bestMatch;
    }

    public static Method findAccessibleMethodIncludeInterfaces(Class start, String methodName, int argCount, Class[] argumentTypes) {
        if (methodName == null) {
            return null;
        }
        Method method = null;
        Class cl = start;
        while (cl != null) {
            Method[] methods = MethodUtils.getPublicDeclaredMethods(cl);
            int i = 0;
            while (i < methods.length) {
                block9: {
                    block10: {
                        method = methods[i];
                        if (method == null) break block9;
                        Class<?>[] params = method.getParameterTypes();
                        if (!method.getName().equals(methodName) || params.length != argCount) break block9;
                        if (argumentTypes == null) break block10;
                        boolean different = false;
                        if (argCount <= 0) break block10;
                        int j = 0;
                        while (j < argCount) {
                            if (params[j] != argumentTypes[j]) {
                                different = true;
                            }
                            ++j;
                        }
                        if (different) break block9;
                    }
                    return method;
                }
                ++i;
            }
            cl = cl.getSuperclass();
        }
        method = null;
        Class<?>[] ifcs = start.getInterfaces();
        int i = 0;
        while (i < ifcs.length) {
            method = MethodUtils.findAccessibleMethodIncludeInterfaces(ifcs[i], methodName, argCount, null);
            if (method != null) break;
            ++i;
        }
        return method;
    }

    public static void flushCaches() {
        declaredMethodCache.clear();
    }

    public static Method getAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] parameterTypes;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> cls = method.getDeclaringClass();
        if (Modifier.isPublic(cls.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(cls, methodName, parameterTypes = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(cls, methodName, parameterTypes);
        }
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                ++i;
            }
            cls = cls.getSuperclass();
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Class<?> parentClass = cls.getSuperclass();
        while (parentClass != null) {
            if (Modifier.isPublic(parentClass.getModifiers())) {
                try {
                    return parentClass.getMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
            parentClass = parentClass.getSuperclass();
        }
        return null;
    }

    public static synchronized Method[] getPublicDeclaredMethods(Class clz) {
        Method[] result = null;
        final Class fclz = clz;
        Reference ref = (Reference)declaredMethodCache.get(fclz);
        if (ref != null && (result = (Method[])ref.get()) != null) {
            return result;
        }
        result = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return fclz.getDeclaredMethods();
            }
        });
        int i = 0;
        while (i < result.length) {
            Method method = result[i];
            int mods = method.getModifiers();
            if (!Modifier.isPublic(mods)) {
                result[i] = null;
            }
            ++i;
        }
        declaredMethodCache.put(fclz, new SoftReference<Method[]>(result));
        return result;
    }

    public static Object invokeExactMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = new Object[]{};
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = new Object[]{};
        }
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = new Object[]{};
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeExactStaticMethod(cls, methodName, args, parameterTypes);
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = new Object[]{};
        }
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        if ((method = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = new Object[]{};
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        if (args == null) {
            args = new Object[]{};
        }
        if ((method = MethodUtils.findAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = new Object[]{};
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return MethodUtils.invokeStaticMethod(cls, methodName, args, parameterTypes);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        if (args == null) {
            args = new Object[]{};
        }
        if ((method = MethodUtils.findAccessibleMethod(cls, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method.invoke(null, args);
    }

    public static boolean throwsException(Method method, Class exception) {
        Class<?>[] exs = method.getExceptionTypes();
        int i = 0;
        while (i < exs.length) {
            if (exs[i] == exception) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

