/*
 * Decompiled with CFR 0.152.
 */
package com.madrobot.text;

import com.madrobot.text.CharUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;

public final class StringUtils {
    public static final String EMPTY = "";
    private static final int PAD_LIMIT = 8192;
    private static final char SPACE = ' ';
    public static final Charset UTF8 = Charset.forName("UTF8");

    public static boolean containsAlphabets(String string) {
        int i = 0;
        while (i < string.length()) {
            if (CharUtils.isLetter(string.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsNumbers(String string) {
        int i = 0;
        while (i < string.length()) {
            if (CharUtils.isDigit(string.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isJsonObject(String s) {
        if (s.startsWith("{") || s.startsWith("[") || s.equals("true") || s.equals("false") || s.equals("null")) {
            return true;
        }
        try {
            new Integer(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String defaultString(String str) {
        return str == null ? EMPTY : str;
    }

    public static String deleteWhitespace(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        int i = 0;
        while (i < sz) {
            if (!Character.isWhitespace(str.charAt(i))) {
                chs[count++] = str.charAt(i);
            }
            ++i;
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str2 == null || str1.length() != str2.length()) {
            return false;
        }
        return str1.toLowerCase().equals(str2.toLowerCase());
    }

    public static String format(String pattern, Object[] args) {
        if (pattern != null) {
            StringBuilder toAppendTo = new StringBuilder();
            int l = pattern.length();
            int n = 0;
            int lIndex = -1;
            int lastIndex = 0;
            int i = 0;
            while (i < l) {
                if (pattern.charAt(i) == '{' && ++n == 1) {
                    lIndex = i;
                    toAppendTo.append(pattern.substring(lastIndex, i));
                    lastIndex = i;
                }
                if (pattern.charAt(i) == '}') {
                    if (n == 1) {
                        toAppendTo.append(StringUtils.processPattern(pattern.substring(lIndex + 1, i), args));
                        lIndex = -1;
                        lastIndex = i + 1;
                    }
                    --n;
                }
                ++i;
            }
            if (n > 0) {
                toAppendTo.append(StringUtils.processPattern(pattern.substring(lIndex + 1), args));
            } else {
                toAppendTo.append(pattern.substring(lastIndex));
            }
            return toAppendTo.toString();
        }
        return null;
    }

    public static String fromUTF8(byte[] ao) {
        int nLength = ao.length;
        char[] ach = new char[nLength];
        int nCount = 0;
        int i = 0;
        while (i < nLength) {
            block5: {
                int nCharCode;
                block3: {
                    block4: {
                        nCharCode = ao[i] & 0xFF;
                        if (nCharCode < 128) break block3;
                        if (nCharCode >= 224) break block4;
                        nCharCode = (nCharCode & 0x1F) << 6;
                        nCharCode |= ao[++i] & 0x3F;
                        break block3;
                    }
                    nCharCode = (nCharCode & 0xF) << 12;
                    nCharCode |= (ao[++i] & 0x3F) << 6;
                    if ((nCharCode |= ao[++i] & 0x3F) == 65279) break block5;
                }
                ach[nCount++] = (char)nCharCode;
            }
            ++i;
        }
        return new String(ach, 0, nCount);
    }

    public static byte[] getBytesIso8859_1(String string) {
        return StringUtils.getBytesUnchecked(string, "ISO-8859-1");
    }

    public static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getBytesUsAscii(String string) {
        return StringUtils.getBytesUnchecked(string, "US-ASCII");
    }

    public static int indexOf(String str, int searchChar, int startPos) {
        if (StringUtils.isBlank(str)) {
            return -1;
        }
        return str.indexOf(searchChar, startPos);
    }

    public static int indexOf(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.indexOf(searchStr, startPos);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isConsecutive(char[] array, char chr) {
        boolean firstPosSet = false;
        int firstPos = 0;
        int secPos = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] == chr) {
                if (!firstPosSet) {
                    firstPos = i;
                    firstPosSet = true;
                } else if (secPos == 0) {
                    secPos = i;
                }
            }
            ++i;
        }
        return secPos == firstPos + 1;
    }

    public static boolean isConsecutive(String string, char chr) {
        return StringUtils.isConsecutive(string.toCharArray(), chr);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String javaDecode(String s) throws Exception {
        int length = s.length();
        StringBuilder buff = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            block20: {
                char c;
                block19: {
                    c = s.charAt(i);
                    if (c != '\\') break block19;
                    if (i + 1 >= s.length()) {
                        throw new Exception("String format error");
                    }
                    c = s.charAt(++i);
                    switch (c) {
                        case 't': {
                            buff.append('\t');
                            break block20;
                        }
                        case 'r': {
                            buff.append('\r');
                            break block20;
                        }
                        case 'n': {
                            buff.append('\n');
                            break block20;
                        }
                        case 'b': {
                            buff.append('\b');
                            break block20;
                        }
                        case 'f': {
                            buff.append('\f');
                            break block20;
                        }
                        case '#': {
                            buff.append('#');
                            break block20;
                        }
                        case '=': {
                            buff.append('=');
                            break block20;
                        }
                        case ':': {
                            buff.append(':');
                            break block20;
                        }
                        case '\"': {
                            buff.append('\"');
                            break block20;
                        }
                        case '\\': {
                            buff.append('\\');
                            break block20;
                        }
                        case 'u': {
                            try {
                                c = (char)Integer.parseInt(s.substring(i + 1, i + 5), 16);
                            }
                            catch (NumberFormatException e) {
                                throw new Exception("String format error");
                            }
                            i += 4;
                            buff.append(c);
                            break block20;
                        }
                        default: {
                            if (c < '0' || c > '9') throw new Exception("String format error");
                            try {
                                c = (char)Integer.parseInt(s.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException e) {
                                throw new Exception("String format error");
                            }
                            i += 2;
                            buff.append(c);
                            break block20;
                        }
                    }
                }
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    public static String javaEncode(String s) {
        int length = s.length();
        StringBuilder buff = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    buff.append("\\t");
                    break;
                }
                case '\n': {
                    buff.append("\\n");
                    break;
                }
                case '\f': {
                    buff.append("\\f");
                    break;
                }
                case '\r': {
                    buff.append("\\r");
                    break;
                }
                case '\"': {
                    buff.append("\\\"");
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                default: {
                    int ch = c & 0xFFFF;
                    if (ch >= 32 && ch < 128) {
                        buff.append(c);
                        break;
                    }
                    buff.append("\\u");
                    String hex = Integer.toHexString(ch);
                    int len = hex.length();
                    while (len < 4) {
                        buff.append('0');
                        ++len;
                    }
                    buff.append(hex);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    public static String join(String[] string) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < string.length) {
            buf.append(string[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String joinWithChar(String[] string, char chr) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < string.length) {
            buf.append(string[i]);
            buf.append(chr);
            ++i;
        }
        return buf.toString();
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtils.padding(pads, padChar).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        int i = 0;
        while (i < pads) {
            padding[i] = padChars[i % padLen];
            ++i;
        }
        return new String(padding).concat(str);
    }

    public static String overlay(String str, String overlay, int start, int end) {
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int len = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return new StringBuilder(len + start - end + overlay.length() + 1).append(str.substring(0, start)).append(overlay).append(str.substring(end)).toString();
    }

    public static String padCenter(String str, int width) {
        if (str.length() > width) {
            return str.substring(0, width);
        }
        boolean rigth = true;
        StringBuilder padded = new StringBuilder(str);
        while (padded.length() < width) {
            if (rigth) {
                padded.append(' ');
            } else {
                padded.insert(0, ' ');
            }
            boolean bl = rigth = !rigth;
        }
        return padded.toString();
    }

    private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        int i = 0;
        while (i < buf.length) {
            buf[i] = padChar;
            ++i;
        }
        return new String(buf);
    }

    private static String processPattern(String indexString, Object[] args) {
        try {
            int index = Integer.parseInt(indexString);
            if (args != null && index >= 0 && index < args.length && args[index] != null) {
                return args[index].toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "?";
    }

    public static String removeExtraSpaces(String string, boolean removeLeadTrailSpaces) {
        StringBuilder buffer = new StringBuilder();
        if (removeLeadTrailSpaces) {
            string = string.trim();
        }
        boolean wasASpace = false;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ' ' || !wasASpace) {
                wasASpace = string.charAt(i) == ' ';
                buffer.append(string.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.padding(repeat, str.charAt(0));
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = str.charAt(0);
                char[] output1 = new char[outputLength];
                int i = repeat - 1;
                while (i >= 0) {
                    output1[i] = ch;
                    --i;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                int i = repeat * 2 - 2;
                while (i >= 0) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        int i = 0;
        while (i < repeat) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (StringUtils.isBlank(text) || StringUtils.isBlank(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceLast(String input, String search, String replace) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            int lastPos = pos;
            while ((pos = input.indexOf(search, lastPos + 1)) != -1) {
                lastPos = pos;
            }
            input = String.valueOf(input.substring(0, lastPos)) + replace + input.substring(lastPos + search.length());
        }
        return input;
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, 1);
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtils.padding(pads, padChar));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        int i = 0;
        while (i < pads) {
            padding[i] = padChars[i % padLen];
            ++i;
        }
        return str.concat(new String(padding));
    }

    public static boolean startsWithIgnoreCase(String base, String start) {
        if (base.length() < start.length()) {
            return false;
        }
        return base.regionMatches(true, 0, start, 0, start.length());
    }

    public static String strip(String str, String stripChars) {
        String result = str;
        if (!StringUtils.isBlank(str)) {
            result = StringUtils.stripEnd(StringUtils.stripStart(str, stripChars), stripChars);
        }
        return result;
    }

    public static String strip(String str, String[] toStrip) {
        int i = 0;
        while (i < toStrip.length) {
            str = str.replace(toStrip[i], EMPTY);
            ++i;
        }
        return str;
    }

    public static String stripEnd(String str, String stripChars) {
        String result = str;
        if (!StringUtils.isBlank(str)) {
            int end = str.length();
            if (stripChars == null) {
                while (end != 0 && ' ' == str.charAt(end - 1)) {
                    --end;
                }
            } else if (stripChars.length() != 0) {
                while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                    --end;
                }
            }
            result = str.substring(0, end);
        }
        return result;
    }

    public static String stripStart(String str, String stripChars) {
        String result = str;
        if (!StringUtils.isBlank(str)) {
            int start = 0;
            if (stripChars == null) {
                while (start != str.length() && ' ' == str.charAt(start)) {
                    ++start;
                }
            } else if (stripChars.length() != 0) {
                while (start != str.length() && stripChars.indexOf(str.charAt(start)) != -1) {
                    ++start;
                }
            }
            result = str.substring(start);
        }
        return result;
    }

    public static CharSequence subSequence(CharSequence cs, int start) {
        return cs == null ? null : cs.subSequence(start, cs.length());
    }

    public static String uncapitalize(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        int strLen = cs.length();
        if (strLen == 0) {
            return cs.toString();
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(cs.charAt(0))).append(StringUtils.subSequence(cs, 1)).toString();
    }

    public static byte[] getUTF8Bytes(CharSequence s) {
        ByteBuffer bb = UTF8.encode(CharBuffer.wrap(s));
        byte[] ret = new byte[bb.remaining()];
        bb.get(ret);
        return ret;
    }

    public static CharSequence fromUTF8Bytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = UTF8.decode(bb);
        return charBuffer;
    }

    public static String[] toStringArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static int countMatches(String str, String sub) {
        if (str == null || str.length() == 0 || sub == null || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String simpleUncapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private StringUtils() {
    }
}

