/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.security.jwt;

import com.manydesigns.portofino.dispatcher.security.jwt.CookieJWTFilter;
import com.manydesigns.portofino.dispatcher.security.jwt.JSONWebToken;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JWTFilter
extends PathMatchingFilter {
    private static final Logger logger = LoggerFactory.getLogger(CookieJWTFilter.class);

    protected boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletResponse httpResponse;
        HttpServletRequest httpRequest;
        String jwt;
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            subject.logout();
        }
        if ((jwt = this.getToken(httpRequest = WebUtils.toHttp((ServletRequest)request), httpResponse = WebUtils.toHttp((ServletResponse)response), mappedValue)) == null) {
            httpResponse.setStatus(401);
            return false;
        }
        try {
            subject.login((AuthenticationToken)new JSONWebToken(jwt));
            return true;
        }
        catch (AuthenticationException e) {
            logger.warn("Failed JWT authentication to " + httpRequest.getRequestURL(), (Throwable)e);
            httpResponse.setStatus(401);
            return false;
        }
    }

    protected abstract String getToken(HttpServletRequest var1, HttpServletResponse var2, Object var3);

    protected String getHost(ServletRequest request) {
        return request.getRemoteHost();
    }
}

