/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.resolvers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.manydesigns.portofino.dispatcher.resolvers.AbstractResourceResolver;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;

public class JacksonResourceResolver
extends AbstractResourceResolver {
    protected final ObjectMapper objectMapper;

    public JacksonResourceResolver(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JacksonResourceResolver() {
        this(new ObjectMapper());
    }

    @Override
    public boolean supports(Class<?> type) {
        return type != Class.class && this.objectMapper.canDeserialize(TypeFactory.defaultInstance().constructType(type));
    }

    @Override
    public boolean supports(String extension) {
        return "json".equals(extension);
    }

    @Override
    public <T> T resolve(FileObject location, Class<T> type) throws Exception {
        FileObject resource = this.resolve(location);
        if (resource == null) {
            return null;
        }
        try (InputStream inputStream = resource.getContent().getInputStream();){
            Object object = this.objectMapper.readValue(inputStream, type);
            return (T)object;
        }
    }
}

