/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.security;

import com.manydesigns.portofino.dispatcher.security.OperationPermission;
import com.manydesigns.portofino.dispatcher.security.SecureResource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.authz.Permission;

public class ResourcePermissions {
    protected final SecureResource resource;
    protected final Map<String, List<Permission>> allow;
    protected final Map<String, List<Permission>> deny;

    public ResourcePermissions(SecureResource resource, Map<String, List<Permission>> allow, Map<String, List<Permission>> deny) {
        this.resource = resource;
        this.allow = new ConcurrentHashMap<String, List<Permission>>();
        this.deny = new ConcurrentHashMap<String, List<Permission>>();
        if (resource.getParent() instanceof SecureResource) {
            this.allow.putAll(((SecureResource)resource.getParent()).getPermissions().getAllow());
            this.deny.putAll(((SecureResource)resource.getParent()).getPermissions().getDeny());
        }
        if (allow != null) {
            this.allow.putAll(allow);
        }
        if (deny != null) {
            this.deny.putAll(deny);
        }
    }

    public OperationPermission getPermission(Permission permission) {
        return new OperationPermission(this.allow, this.deny, permission);
    }

    public SecureResource getResource() {
        return this.resource;
    }

    public Map<String, List<Permission>> getAllow() {
        return this.allow;
    }

    public Map<String, List<Permission>> getDeny() {
        return this.deny;
    }
}

