/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.ConflictResolutionMode;
import com.azure.data.cosmos.JsonSerializable;
import com.azure.data.cosmos.internal.Strings;

public class ConflictResolutionPolicy
extends JsonSerializable {
    public static ConflictResolutionPolicy createLastWriterWinsPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.mode(ConflictResolutionMode.LAST_WRITER_WINS);
        return policy;
    }

    public static ConflictResolutionPolicy createLastWriterWinsPolicy(String conflictResolutionPath) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.mode(ConflictResolutionMode.LAST_WRITER_WINS);
        if (conflictResolutionPath != null) {
            policy.conflictResolutionPath(conflictResolutionPath);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy(String conflictResolutionSprocName) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.mode(ConflictResolutionMode.CUSTOM);
        if (conflictResolutionSprocName != null) {
            policy.conflictResolutionProcedure(conflictResolutionSprocName);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.mode(ConflictResolutionMode.CUSTOM);
        return policy;
    }

    ConflictResolutionPolicy() {
    }

    public ConflictResolutionPolicy(String jsonString) {
        super(jsonString);
    }

    public ConflictResolutionMode mode() {
        String strValue = super.getString("mode");
        if (!Strings.isNullOrEmpty(strValue)) {
            try {
                return ConflictResolutionMode.valueOf(Strings.fromCamelCaseToUpperCase(super.getString("mode")));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warn("INVALID ConflictResolutionMode value {}.", (Object)super.getString("mode"));
                return ConflictResolutionMode.INVALID;
            }
        }
        return ConflictResolutionMode.INVALID;
    }

    ConflictResolutionPolicy mode(ConflictResolutionMode mode) {
        super.set("mode", mode.toString());
        return this;
    }

    public String conflictResolutionPath() {
        return super.getString("conflictResolutionPath");
    }

    ConflictResolutionPolicy conflictResolutionPath(String value) {
        super.set("conflictResolutionPath", value);
        return this;
    }

    public String conflictResolutionProcedure() {
        return super.getString("conflictResolutionProcedure");
    }

    ConflictResolutionPolicy conflictResolutionProcedure(String value) {
        super.set("conflictResolutionProcedure", value);
        return this;
    }
}

