/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.ConflictResolutionPolicy;
import com.azure.data.cosmos.IndexingPolicy;
import com.azure.data.cosmos.PartitionKeyDefinition;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.UniqueKeyPolicy;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.ResourceResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CosmosContainerProperties
extends Resource {
    private IndexingPolicy indexingPolicy;
    private UniqueKeyPolicy uniqueKeyPolicy;
    private PartitionKeyDefinition partitionKeyDefinition;

    public CosmosContainerProperties(String id, String partitionKeyPath) {
        super.id(id);
        PartitionKeyDefinition partitionKeyDef = new PartitionKeyDefinition();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(partitionKeyPath);
        partitionKeyDef.paths(paths);
        this.partitionKeyDefinition(partitionKeyDef);
    }

    public CosmosContainerProperties(String id, PartitionKeyDefinition partitionKeyDefinition) {
        super.id(id);
        this.partitionKeyDefinition(partitionKeyDefinition);
    }

    CosmosContainerProperties(ResourceResponse<DocumentCollection> response) {
        super(response.getResource().toJson());
    }

    CosmosContainerProperties(DocumentCollection collection) {
        super(collection.toJson());
    }

    static List<CosmosContainerProperties> getFromV2Results(List<DocumentCollection> results) {
        return results.stream().map(CosmosContainerProperties::new).collect(Collectors.toList());
    }

    public IndexingPolicy indexingPolicy() {
        if (this.indexingPolicy == null) {
            this.indexingPolicy = super.has("indexingPolicy") ? super.getObject("indexingPolicy", IndexingPolicy.class, new boolean[0]) : new IndexingPolicy();
        }
        return this.indexingPolicy;
    }

    public CosmosContainerProperties indexingPolicy(IndexingPolicy indexingPolicy) {
        if (indexingPolicy == null) {
            throw new IllegalArgumentException("IndexingPolicy cannot be null.");
        }
        this.indexingPolicy = indexingPolicy;
        super.set("indexingPolicy", indexingPolicy);
        return this;
    }

    public UniqueKeyPolicy uniqueKeyPolicy() {
        if (this.uniqueKeyPolicy == null) {
            this.uniqueKeyPolicy = super.getObject("uniqueKeyPolicy", UniqueKeyPolicy.class, new boolean[0]);
            if (this.uniqueKeyPolicy == null) {
                this.uniqueKeyPolicy = new UniqueKeyPolicy();
            }
        }
        return this.uniqueKeyPolicy;
    }

    public CosmosContainerProperties uniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        if (uniqueKeyPolicy == null) {
            throw new IllegalArgumentException("uniqueKeyPolicy cannot be null.");
        }
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        super.set("uniqueKeyPolicy", uniqueKeyPolicy);
        return this;
    }

    public PartitionKeyDefinition partitionKeyDefinition() {
        if (this.partitionKeyDefinition == null) {
            this.partitionKeyDefinition = super.has("partitionKey") ? super.getObject("partitionKey", PartitionKeyDefinition.class, new boolean[0]) : new PartitionKeyDefinition();
        }
        return this.partitionKeyDefinition;
    }

    public CosmosContainerProperties partitionKeyDefinition(PartitionKeyDefinition partitionKeyDefinition) {
        if (partitionKeyDefinition == null) {
            throw new IllegalArgumentException("partitionKeyDefinition cannot be null.");
        }
        this.partitionKeyDefinition = partitionKeyDefinition;
        return this;
    }

    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return super.getObject("conflictResolutionPolicy", ConflictResolutionPolicy.class, new boolean[0]);
    }

    public CosmosContainerProperties conflictResolutionPolicy(ConflictResolutionPolicy value) {
        if (value == null) {
            throw new IllegalArgumentException("CONFLICT_RESOLUTION_POLICY cannot be null.");
        }
        super.set("conflictResolutionPolicy", value);
        return this;
    }

    public Integer defaultTimeToLive() {
        if (super.has("defaultTtl")) {
            return super.getInt("defaultTtl");
        }
        return null;
    }

    public void defaultTimeToLive(Integer timeToLive) {
        if (timeToLive != null) {
            super.set("defaultTtl", timeToLive);
        } else if (super.has("defaultTtl")) {
            super.remove("defaultTtl");
        }
    }

    DocumentCollection getV2Collection() {
        DocumentCollection collection = new DocumentCollection(this.toJson());
        collection.setPartitionKey(this.partitionKeyDefinition());
        collection.setIndexingPolicy(this.indexingPolicy());
        return collection;
    }
}

