/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosItem;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.internal.Document;
import com.azure.data.cosmos.internal.ResourceResponse;

public class CosmosItemResponse
extends CosmosResponse<CosmosItemProperties> {
    private CosmosItem itemClient;

    CosmosItemResponse(ResourceResponse<Document> response, PartitionKey partitionKey, CosmosContainer container) {
        super(response);
        if (response.getResource() == null) {
            super.resourceSettings(null);
        } else {
            super.resourceSettings(new CosmosItemProperties(response.getResource().toJson()));
            this.itemClient = new CosmosItem(response.getResource().id(), partitionKey, container);
        }
    }

    public CosmosItemProperties properties() {
        return (CosmosItemProperties)this.resourceSettings();
    }

    public CosmosItem item() {
        return this.itemClient;
    }
}

