/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.TriggerOperation;
import com.azure.data.cosmos.TriggerType;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.Trigger;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CosmosTriggerProperties
extends Resource {
    public CosmosTriggerProperties() {
    }

    CosmosTriggerProperties(String jsonString) {
        super(jsonString);
    }

    CosmosTriggerProperties(ResourceResponse<Trigger> response) {
        super(response.getResource().toJson());
    }

    @Override
    public CosmosTriggerProperties id(String id) {
        super.id(id);
        return this;
    }

    public String body() {
        return super.getString("body");
    }

    public CosmosTriggerProperties body(String body) {
        super.set("body", body);
        return this;
    }

    public TriggerType triggerType() {
        TriggerType result = TriggerType.PRE;
        try {
            result = TriggerType.valueOf(StringUtils.upperCase((String)super.getString("triggerType")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID triggerType value {}.", (Object)super.getString("triggerType"));
        }
        return result;
    }

    public CosmosTriggerProperties triggerType(TriggerType triggerType) {
        super.set("triggerType", triggerType.toString());
        return this;
    }

    public TriggerOperation triggerOperation() {
        TriggerOperation result = TriggerOperation.CREATE;
        try {
            result = TriggerOperation.valueOf(StringUtils.upperCase((String)super.getString("triggerOperation")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID triggerOperation value {}.", (Object)super.getString("triggerOperation"));
        }
        return result;
    }

    public CosmosTriggerProperties triggerOperation(TriggerOperation triggerOperation) {
        super.set("triggerOperation", triggerOperation.toString());
        return this;
    }

    static List<CosmosTriggerProperties> getFromV2Results(List<Trigger> results) {
        return results.stream().map(trigger -> new CosmosTriggerProperties(trigger.toJson())).collect(Collectors.toList());
    }
}

