/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosError;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.data.cosmos.internal.http.HttpHeaders;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class GoneException
extends CosmosClientException {
    public GoneException(String msg) {
        this(msg, (String)null);
    }

    public GoneException() {
        this("The requested resource is no longer available at the server.", (String)null);
    }

    public GoneException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public GoneException(String message, String requestUri) {
        this(message, null, new HashMap<String, String>(), requestUri);
    }

    GoneException(String message, Exception innerException, URI requestUri, String localIpAddress) {
        this(GoneException.message(localIpAddress, message), innerException, null, requestUri);
    }

    GoneException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, new HashMap<String, String>(), null);
    }

    public GoneException(String message, HttpHeaders headers, URI requestUrl) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUrl != null ? requestUrl.toString() : null);
    }

    GoneException(String message, HttpHeaders headers, String requestUriString) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUriString);
    }

    public GoneException(String message, Exception innerException, HttpHeaders headers, URI requestUrl) {
        super(message, innerException, HttpUtils.asMap(headers), 410, requestUrl != null ? requestUrl.toString() : null);
    }

    public GoneException(String message, Exception innerException, Map<String, String> headers, String requestUriString) {
        super(message, innerException, headers, 410, requestUriString);
    }

    GoneException(CosmosError cosmosError, Map<String, String> headers) {
        super(410, cosmosError, headers);
    }

    private static String message(String localIP, String baseMessage) {
        if (!Strings.isNullOrEmpty(localIP)) {
            return String.format("%s, Local IP: %s", baseMessage, localIP);
        }
        return baseMessage;
    }
}

