/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosError;
import com.azure.data.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.data.cosmos.internal.http.HttpHeaders;
import java.util.Map;

public class PartitionKeyRangeGoneException
extends CosmosClientException {
    public PartitionKeyRangeGoneException() {
        this("The requested resource is no longer available at the server.");
    }

    public PartitionKeyRangeGoneException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
        this.setSubstatus();
    }

    public PartitionKeyRangeGoneException(String message) {
        this(message, null, null, null);
    }

    PartitionKeyRangeGoneException(String message, Exception innerException) {
        this(message, innerException, null, null);
    }

    PartitionKeyRangeGoneException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, null, null);
    }

    public PartitionKeyRangeGoneException(String message, HttpHeaders headers, String requestUriString) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUriString);
        this.setSubstatus();
    }

    PartitionKeyRangeGoneException(String message, Exception innerException, HttpHeaders headers, String requestUriString) {
        super(message, innerException, HttpUtils.asMap(headers), 410, requestUriString);
        this.setSubstatus();
    }

    private void setSubstatus() {
        this.responseHeaders().put("x-ms-substatus", Integer.toString(1002));
    }
}

