/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.changefeed.implementation;

import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.internal.changefeed.ChangeFeedObserverContext;
import com.azure.data.cosmos.internal.changefeed.Lease;
import com.azure.data.cosmos.internal.changefeed.PartitionCheckpointer;
import reactor.core.publisher.Mono;

class ChangeFeedObserverContextImpl
implements ChangeFeedObserverContext {
    private final PartitionCheckpointer checkpointer;
    private final String partitionKeyRangeId;
    private final FeedResponse<CosmosItemProperties> feedResponse;
    private String responseContinuation;

    public ChangeFeedObserverContextImpl(String leaseToken) {
        this.partitionKeyRangeId = leaseToken;
        this.checkpointer = null;
        this.feedResponse = null;
    }

    public ChangeFeedObserverContextImpl(String leaseToken, FeedResponse<CosmosItemProperties> feedResponse, PartitionCheckpointer checkpointer) {
        this.partitionKeyRangeId = leaseToken;
        this.feedResponse = feedResponse;
        this.checkpointer = checkpointer;
    }

    @Override
    public Mono<Lease> checkpoint() {
        this.responseContinuation = this.feedResponse.continuationToken();
        return this.checkpointer.checkpointPartition(this.responseContinuation);
    }

    @Override
    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    @Override
    public FeedResponse<CosmosItemProperties> getFeedResponse() {
        return this.feedResponse;
    }
}

