/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.GoneException;
import com.azure.data.cosmos.InvalidPartitionException;
import com.azure.data.cosmos.PartitionIsMigratingException;
import com.azure.data.cosmos.PartitionKeyRangeGoneException;
import com.azure.data.cosmos.PartitionKeyRangeIsSplittingException;
import com.azure.data.cosmos.RetryWithException;
import com.azure.data.cosmos.internal.IRetryPolicy;
import com.azure.data.cosmos.internal.Quadruple;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import java.time.Duration;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class GoneAndRetryWithRetryPolicy
implements IRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(GoneAndRetryWithRetryPolicy.class);
    private static final int DEFAULT_WAIT_TIME_IN_SECONDS = 30;
    private static final int MAXIMUM_BACKOFF_TIME_IN_SECONDS = 15;
    private static final int INITIAL_BACKOFF_TIME = 1;
    private static final int BACK_OFF_MULTIPLIER = 2;
    private final RxDocumentServiceRequest request;
    private volatile int attemptCount = 1;
    private volatile int attemptCountInvalidPartition = 1;
    private volatile int currentBackoffSeconds = 1;
    private volatile RetryWithException lastRetryWithException;
    private final StopWatch durationTimer = new StopWatch();
    private final int waitTimeInSeconds;
    public static Quadruple<Boolean, Boolean, Duration, Integer> INITIAL_ARGUMENT_VALUE_POLICY_ARG = Quadruple.with(false, false, Duration.ofSeconds(60L), 0);

    public GoneAndRetryWithRetryPolicy(RxDocumentServiceRequest request, Integer waitTimeInSeconds) {
        this.request = request;
        this.startStopWatch(this.durationTimer);
        this.waitTimeInSeconds = waitTimeInSeconds != null ? waitTimeInSeconds : 30;
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception exception) {
        long timeoutInMillSec;
        CosmosClientException exceptionToThrow = null;
        Duration backoffTime = Duration.ofSeconds(0L);
        Duration timeout = Duration.ofSeconds(0L);
        boolean forceRefreshAddressCache = false;
        if (!(exception instanceof GoneException || exception instanceof RetryWithException || exception instanceof PartitionIsMigratingException || exception instanceof InvalidPartitionException && (this.request.getPartitionKeyRangeIdentity() == null || this.request.getPartitionKeyRangeIdentity().getCollectionRid() == null) || exception instanceof PartitionKeyRangeIsSplittingException)) {
            logger.debug("Operation will NOT be retried. Current attempt {}, Exception:", (Object)this.attemptCount, (Object)exception);
            this.stopStopWatch(this.durationTimer);
            return Mono.just((Object)IRetryPolicy.ShouldRetryResult.noRetry());
        }
        if (exception instanceof RetryWithException) {
            this.lastRetryWithException = (RetryWithException)exception;
        }
        long remainingSeconds = (long)this.waitTimeInSeconds - this.durationTimer.getTime() / 1000L;
        int currentRetryAttemptCount = this.attemptCount;
        if (this.attemptCount++ > 1) {
            if (remainingSeconds <= 0L) {
                if (exception instanceof GoneException) {
                    if (this.lastRetryWithException != null) {
                        logger.warn("Received gone exception after backoff/retry including at least one RetryWithException. Will fail the request with RetryWithException. GoneException: {}. RetryWithException: {}", (Object)exception, (Object)this.lastRetryWithException);
                        exceptionToThrow = this.lastRetryWithException;
                    } else {
                        logger.warn("Received gone exception after backoff/retry. Will fail the request. {}", (Object)exception.toString());
                        exceptionToThrow = BridgeInternal.createCosmosClientException(503, exception);
                    }
                } else if (exception instanceof PartitionKeyRangeGoneException) {
                    if (this.lastRetryWithException != null) {
                        logger.warn("Received partition key range gone exception after backoff/retry including at least one RetryWithException.Will fail the request with RetryWithException. GoneException: {}. RetryWithException: {}", (Object)exception, (Object)this.lastRetryWithException);
                        exceptionToThrow = this.lastRetryWithException;
                    } else {
                        logger.warn("Received partition key range gone exception after backoff/retry. Will fail the request. {}", (Object)exception.toString());
                        exceptionToThrow = BridgeInternal.createCosmosClientException(503, exception);
                    }
                } else if (exception instanceof InvalidPartitionException) {
                    if (this.lastRetryWithException != null) {
                        logger.warn("Received InvalidPartitionException after backoff/retry including at least one RetryWithException. Will fail the request with RetryWithException. InvalidPartitionException: {}. RetryWithException: {}", (Object)exception, (Object)this.lastRetryWithException);
                    } else {
                        logger.warn("Received invalid collection partition exception after backoff/retry. Will fail the request. {}", (Object)exception.toString());
                        exceptionToThrow = BridgeInternal.createCosmosClientException(503, exception);
                    }
                } else {
                    logger.warn("Received retrywith exception after backoff/retry. Will fail the request. {}", (Object)exception.toString());
                }
                this.stopStopWatch(this.durationTimer);
                return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(exceptionToThrow));
            }
            backoffTime = Duration.ofSeconds(Math.min(Math.min((long)this.currentBackoffSeconds, remainingSeconds), 15L));
            this.currentBackoffSeconds *= 2;
            logger.info("BackoffTime: {} seconds.", (Object)backoffTime.getSeconds());
        }
        Duration duration = timeout = (timeoutInMillSec = remainingSeconds * 1000L - backoffTime.toMillis()) > 0L ? Duration.ofMillis(timeoutInMillSec) : Duration.ofSeconds(15L);
        if (exception instanceof GoneException) {
            logger.warn("Received gone exception, will retry, {}", (Object)exception.toString());
            forceRefreshAddressCache = true;
        } else if (exception instanceof PartitionIsMigratingException) {
            logger.warn("Received PartitionIsMigratingException, will retry, {}", (Object)exception.toString());
            this.request.forceCollectionRoutingMapRefresh = true;
            forceRefreshAddressCache = true;
        } else if (exception instanceof InvalidPartitionException) {
            this.request.requestContext.quorumSelectedLSN = -1L;
            this.request.requestContext.resolvedPartitionKeyRange = null;
            this.request.requestContext.quorumSelectedStoreResponse = null;
            this.request.requestContext.globalCommittedSelectedLSN = -1L;
            if (this.attemptCountInvalidPartition++ > 2) {
                logger.warn("Received second InvalidPartitionException after backoff/retry. Will fail the request. {}", (Object)exception.toString());
                return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(BridgeInternal.createCosmosClientException(503, exception)));
            }
            if (this.request == null) {
                logger.error("Received unexpected invalid collection exception, request should be non-null.", (Throwable)exception);
                return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(BridgeInternal.createCosmosClientException(500, exception)));
            }
            logger.warn("Received invalid collection exception, will retry, {}", (Object)exception.toString());
            this.request.forceNameCacheRefresh = true;
            forceRefreshAddressCache = false;
        } else if (exception instanceof PartitionKeyRangeIsSplittingException) {
            this.request.requestContext.resolvedPartitionKeyRange = null;
            this.request.requestContext.quorumSelectedLSN = -1L;
            this.request.requestContext.quorumSelectedStoreResponse = null;
            logger.info("Received partition key range splitting exception, will retry, {}", (Object)exception.toString());
            this.request.forcePartitionKeyRangeRefresh = true;
            forceRefreshAddressCache = false;
        } else {
            logger.warn("Received retrywith exception, will retry, {}", (Throwable)exception);
            forceRefreshAddressCache = false;
        }
        return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(backoffTime, Quadruple.with(forceRefreshAddressCache, true, timeout, currentRetryAttemptCount)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.start();
        }
    }
}

