/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.ServerProperties;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdConstants;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdContextException;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdContextRequest;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdFramer;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdResponseStatus;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdToken;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdTokenStream;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;

public final class RntbdContext {
    private final UUID activityId;
    private final HttpResponseStatus status;
    private final String clientVersion;
    private final long idleTimeoutInSeconds;
    private final int protocolVersion;
    private final ServerProperties serverProperties;
    private final long unauthenticatedTimeoutInSeconds;

    private RntbdContext(RntbdResponseStatus responseStatus, Headers headers) {
        this.activityId = responseStatus.getActivityId();
        this.status = responseStatus.getStatus();
        this.clientVersion = headers.clientVersion.getValue(String.class);
        this.idleTimeoutInSeconds = headers.idleTimeoutInSeconds.getValue(Long.class);
        this.protocolVersion = headers.protocolVersion.getValue(Long.class).intValue();
        this.unauthenticatedTimeoutInSeconds = headers.unauthenticatedTimeoutInSeconds.getValue(Long.class);
        this.serverProperties = new ServerProperties(headers.serverAgent.getValue(String.class), headers.serverVersion.getValue(String.class));
    }

    @JsonProperty
    public UUID activityId() {
        return this.activityId;
    }

    @JsonProperty
    public String clientVersion() {
        return this.clientVersion;
    }

    @JsonProperty
    public long idleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    @JsonProperty
    public int protocolVersion() {
        return this.protocolVersion;
    }

    @JsonProperty
    public ServerProperties serverProperties() {
        return this.serverProperties;
    }

    @JsonIgnore
    public String serverVersion() {
        return this.serverProperties.getVersion();
    }

    @JsonIgnore
    public HttpResponseStatus status() {
        return this.status;
    }

    @JsonProperty
    public int getStatusCode() {
        return this.status.code();
    }

    @JsonProperty
    public long getUnauthenticatedTimeoutInSeconds() {
        return this.unauthenticatedTimeoutInSeconds;
    }

    public static RntbdContext decode(ByteBuf in) {
        in.markReaderIndex();
        RntbdResponseStatus responseStatus = RntbdResponseStatus.decode(in);
        int statusCode = responseStatus.getStatusCode();
        int headersLength = responseStatus.getHeadersLength();
        if (!(statusCode >= 200 && statusCode < 400 || RntbdFramer.canDecodePayload(in, in.readerIndex() + headersLength))) {
            in.resetReaderIndex();
            return null;
        }
        Headers headers = Headers.decode(in.readSlice(headersLength));
        if (statusCode < 200 || statusCode >= 400) {
            ObjectNode details = RntbdObjectMapper.readTree(in.readSlice(in.readIntLE()));
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            if (headers.clientVersion.isPresent()) {
                map.put("requiredClientVersion", headers.clientVersion.getValue());
            }
            if (headers.protocolVersion.isPresent()) {
                map.put("requiredProtocolVersion", headers.protocolVersion.getValue());
            }
            if (headers.serverAgent.isPresent()) {
                map.put("serverAgent", headers.serverAgent.getValue());
            }
            if (headers.serverVersion.isPresent()) {
                map.put("serverVersion", headers.serverVersion.getValue());
            }
            throw new RntbdContextException(responseStatus.getStatus(), details, Collections.unmodifiableMap(map));
        }
        return new RntbdContext(responseStatus, headers);
    }

    public void encode(ByteBuf out) {
        Headers headers = new Headers(this);
        int length = 24 + headers.computeLength();
        RntbdResponseStatus responseStatus = new RntbdResponseStatus(length, this.status(), this.activityId());
        int start = out.writerIndex();
        responseStatus.encode(out);
        headers.encode(out);
        headers.release();
        int end = out.writerIndex();
        Preconditions.checkState((end - start == responseStatus.getLength() ? 1 : 0) != 0);
    }

    public static RntbdContext from(RntbdContextRequest request, ServerProperties properties, HttpResponseStatus status) {
        Headers headers = new Headers(Unpooled.EMPTY_BUFFER);
        headers.clientVersion.setValue(request.getClientVersion());
        headers.idleTimeoutInSeconds.setValue(0);
        headers.protocolVersion.setValue(1);
        headers.serverAgent.setValue(properties.getAgent());
        headers.serverVersion.setValue(properties.getVersion());
        headers.unauthenticatedTimeoutInSeconds.setValue(0);
        int length = 24 + headers.computeLength();
        UUID activityId = request.getActivityId();
        RntbdResponseStatus responseStatus = new RntbdResponseStatus(length, status, activityId);
        return new RntbdContext(responseStatus, headers);
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private static final class Headers
    extends RntbdTokenStream<RntbdConstants.RntbdContextHeader> {
        final RntbdToken clientVersion = this.get(RntbdConstants.RntbdContextHeader.ClientVersion);
        final RntbdToken idleTimeoutInSeconds = this.get(RntbdConstants.RntbdContextHeader.IdleTimeoutInSeconds);
        final RntbdToken protocolVersion = this.get(RntbdConstants.RntbdContextHeader.ProtocolVersion);
        final RntbdToken serverAgent = this.get(RntbdConstants.RntbdContextHeader.ServerAgent);
        final RntbdToken serverVersion = this.get(RntbdConstants.RntbdContextHeader.ServerVersion);
        final RntbdToken unauthenticatedTimeoutInSeconds = this.get(RntbdConstants.RntbdContextHeader.UnauthenticatedTimeoutInSeconds);

        private Headers(RntbdContext context) {
            this(Unpooled.EMPTY_BUFFER);
            this.clientVersion.setValue(context.clientVersion());
            this.idleTimeoutInSeconds.setValue(context.idleTimeoutInSeconds());
            this.protocolVersion.setValue(context.protocolVersion());
            this.serverAgent.setValue(context.serverProperties().getAgent());
            this.serverVersion.setValue(context.serverProperties().getVersion());
            this.unauthenticatedTimeoutInSeconds.setValue(context.unauthenticatedTimeoutInSeconds);
        }

        Headers(ByteBuf in) {
            super(RntbdConstants.RntbdContextHeader.set, RntbdConstants.RntbdContextHeader.map, in);
        }

        static Headers decode(ByteBuf in) {
            Headers headers = new Headers(in);
            Headers.decode(headers);
            return headers;
        }
    }
}

