/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdRequestTimer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RntbdRequestTimer.class);
    private final long requestTimeoutInNanos;
    private final Timer timer;

    public RntbdRequestTimer(long requestTimeoutInNanos, long requestTimerResolutionInNanos) {
        this.timer = new HashedWheelTimer(requestTimerResolutionInNanos, TimeUnit.NANOSECONDS);
        this.requestTimeoutInNanos = requestTimeoutInNanos;
    }

    public long getRequestTimeout(TimeUnit unit) {
        return unit.convert(this.requestTimeoutInNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() {
        int count;
        Set timeouts = this.timer.stop();
        if (logger.isDebugEnabled() && (count = timeouts.size()) > 0) {
            logger.debug("request expiration tasks cancelled: {}", (Object)count);
        }
    }

    public Timeout newTimeout(TimerTask task) {
        return this.timer.newTimeout(task, this.requestTimeoutInNanos, TimeUnit.NANOSECONDS);
    }
}

