/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.internal.Document;
import com.azure.data.cosmos.internal.QueryMetrics;
import com.azure.data.cosmos.internal.Undefined;
import com.azure.data.cosmos.internal.query.IDocumentQueryExecutionComponent;
import com.azure.data.cosmos.internal.query.QueryItem;
import com.azure.data.cosmos.internal.query.aggregation.AggregateOperator;
import com.azure.data.cosmos.internal.query.aggregation.Aggregator;
import com.azure.data.cosmos.internal.query.aggregation.AverageAggregator;
import com.azure.data.cosmos.internal.query.aggregation.CountAggregator;
import com.azure.data.cosmos.internal.query.aggregation.MaxAggregator;
import com.azure.data.cosmos.internal.query.aggregation.MinAggregator;
import com.azure.data.cosmos.internal.query.aggregation.SumAggregator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class AggregateDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private Aggregator aggregator;
    private ConcurrentMap<String, QueryMetrics> queryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>();

    public AggregateDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, Collection<AggregateOperator> aggregateOperators) {
        this.component = component;
        AggregateOperator aggregateOperator = aggregateOperators.iterator().next();
        switch (aggregateOperator) {
            case Average: {
                this.aggregator = new AverageAggregator();
                break;
            }
            case Count: {
                this.aggregator = new CountAggregator();
                break;
            }
            case Max: {
                this.aggregator = new MaxAggregator();
                break;
            }
            case Min: {
                this.aggregator = new MinAggregator();
                break;
            }
            case Sum: {
                this.aggregator = new SumAggregator();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + aggregateOperator.toString());
            }
        }
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).collectList().map(superList -> {
            double requestCharge = 0.0;
            ArrayList<Document> aggregateResults = new ArrayList<Document>();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (FeedResponse page : superList) {
                if (page.results().size() == 0) {
                    headers.put("x-ms-request-charge", Double.toString(requestCharge));
                    FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
                    return frp;
                }
                Document doc = (Document)page.results().get(0);
                requestCharge += page.requestCharge();
                QueryItem values = new QueryItem(doc.toJson());
                this.aggregator.aggregate(values.getItem());
                for (String key : BridgeInternal.queryMetricsFromFeedResponse(page).keySet()) {
                    if (this.queryMetricsMap.containsKey(key)) {
                        QueryMetrics qm = (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(page).get(key);
                        ((QueryMetrics)this.queryMetricsMap.get(key)).add(qm);
                        continue;
                    }
                    this.queryMetricsMap.put(key, (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(page).get(key));
                }
            }
            if (this.aggregator.getResult() == null || !this.aggregator.getResult().equals(Undefined.Value())) {
                Document aggregateDocument = new Document();
                BridgeInternal.setProperty(aggregateDocument, "_aggregate", this.aggregator.getResult());
                aggregateResults.add(aggregateDocument);
            }
            headers.put("x-ms-request-charge", Double.toString(requestCharge));
            FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
            if (!this.queryMetricsMap.isEmpty()) {
                for (String key : this.queryMetricsMap.keySet()) {
                    BridgeInternal.putQueryMetricsIntoMap(frp, key, (QueryMetrics)this.queryMetricsMap.get(key));
                }
            }
            return frp;
        }).flux();
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(Function<String, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, Collection<AggregateOperator> aggregates, String continuationToken) {
        return createSourceComponentFunction.apply(continuationToken).map(component -> new AggregateDocumentQueryExecutionContext(component, aggregates));
    }

    public IDocumentQueryExecutionComponent<T> getComponent() {
        return this.component;
    }
}

