/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BadRequestException;
import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CommonsBridgeInternal;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.caches.RxCollectionCache;
import com.azure.data.cosmos.internal.query.DefaultDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.IDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.PartitionedQueryExecutionInfo;
import com.azure.data.cosmos.internal.query.PipelinedDocumentQueryExecutionContext;
import com.azure.data.cosmos.internal.query.QueryInfo;
import com.azure.data.cosmos.internal.query.QueryPlanRetriever;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternal;
import com.azure.data.cosmos.internal.routing.Range;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DocumentQueryExecutionContextFactory {
    private static final int PageSizeFactorForTop = 5;

    private static Mono<Utils.ValueHolder<DocumentCollection>> resolveCollection(IDocumentQueryClient client, SqlQuerySpec query, ResourceType resourceTypeEnum, String resourceLink) {
        RxCollectionCache collectionCache = client.getCollectionCache();
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Query, resourceTypeEnum, resourceLink, null);
        return collectionCache.resolveCollectionAsync(request);
    }

    public static <T extends Resource> Flux<? extends IDocumentQueryExecutionContext<T>> createDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean isContinuationExpected, UUID correlatedActivityId) {
        Flux collectionObs = Flux.just(new Utils.ValueHolder<Object>(null));
        if (resourceTypeEnum.isCollectionChild()) {
            collectionObs = DocumentQueryExecutionContextFactory.resolveCollection(client, query, resourceTypeEnum, resourceLink).flux();
        }
        DefaultDocumentQueryExecutionContext queryExecutionContext = new DefaultDocumentQueryExecutionContext(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, correlatedActivityId, isContinuationExpected);
        if (ResourceType.Document != resourceTypeEnum) {
            return Flux.just(queryExecutionContext);
        }
        Mono<PartitionedQueryExecutionInfo> queryExecutionInfoMono = QueryPlanRetriever.getQueryPlanThroughGatewayAsync(client, query, resourceLink);
        return collectionObs.single().flatMap(collectionValueHolder -> queryExecutionInfoMono.flatMap(partitionedQueryExecutionInfo -> {
            Mono<List<PartitionKeyRange>> partitionKeyRanges;
            QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
            if (queryInfo.hasAggregates() && !queryInfo.hasSelectValue()) {
                if (feedOptions != null && feedOptions.enableCrossPartitionQuery().booleanValue()) {
                    return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "Cross partition query only supports 'VALUE <AggreateFunc>' for aggregates"));
                }
                return Mono.just((Object)queryExecutionContext);
            }
            if (feedOptions != null && !StringUtils.isEmpty((CharSequence)CommonsBridgeInternal.partitionKeyRangeIdInternal(feedOptions))) {
                partitionKeyRanges = queryExecutionContext.getTargetPartitionKeyRangesById(((DocumentCollection)collectionValueHolder.v).resourceId(), CommonsBridgeInternal.partitionKeyRangeIdInternal(feedOptions));
            } else {
                List<Range<String>> queryRanges = partitionedQueryExecutionInfo.getQueryRanges();
                if (feedOptions != null && feedOptions.partitionKey() != null) {
                    PartitionKeyInternal internalPartitionKey = feedOptions.partitionKey().getInternalPartitionKey();
                    Range<String> range = Range.getPointRange(internalPartitionKey.getEffectivePartitionKeyString(internalPartitionKey, ((DocumentCollection)collectionValueHolder.v).getPartitionKey()));
                    queryRanges = Collections.singletonList(range);
                }
                partitionKeyRanges = queryExecutionContext.getTargetPartitionKeyRanges(((DocumentCollection)collectionValueHolder.v).resourceId(), queryRanges);
            }
            return partitionKeyRanges.flatMap(pkranges -> DocumentQueryExecutionContextFactory.createSpecializedDocumentQueryExecutionContextAsync(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, isContinuationExpected, partitionedQueryExecutionInfo, pkranges, ((DocumentCollection)collectionValueHolder.v).resourceId(), correlatedActivityId).single());
        })).flux();
    }

    public static <T extends Resource> Flux<? extends IDocumentQueryExecutionContext<T>> createSpecializedDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, boolean isContinuationExpected, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, String collectionRid, UUID correlatedActivityId) {
        int top;
        int initialPageSize;
        BadRequestException validationError;
        if (feedOptions == null) {
            feedOptions = new FeedOptions();
        }
        if ((validationError = Utils.checkRequestOrReturnException((initialPageSize = Utils.getValueOrDefault(feedOptions.maxItemCount(), 100)) > 0 || initialPageSize == -1, "MaxItemCount", "Invalid MaxItemCount %s", initialPageSize)) != null) {
            return Flux.error((Throwable)validationError);
        }
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        if (!Strings.isNullOrEmpty(queryInfo.getRewrittenQuery())) {
            query = new SqlQuerySpec(queryInfo.getRewrittenQuery(), query.parameters());
        }
        boolean getLazyFeedResponse = queryInfo.hasTop();
        if (queryInfo.hasOrderBy() && queryInfo.hasTop() && (top = partitionedQueryExecutionInfo.getQueryInfo().getTop().intValue()) > 0) {
            int pageSizeWithTop = Math.min((int)Math.ceil((double)top / (double)targetRanges.size()) * 5, top);
            initialPageSize = initialPageSize > 0 ? Math.min(pageSizeWithTop, initialPageSize) : pageSizeWithTop;
        }
        return PipelinedDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
    }
}

