/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosUser;
import com.azure.data.cosmos.CosmosUserProperties;
import com.azure.data.cosmos.sync.CosmosSyncDatabase;
import com.azure.data.cosmos.sync.CosmosSyncUserResponse;

public class CosmosSyncUser {
    private final CosmosUser asyncUser;
    private final CosmosSyncDatabase database;
    private final String id;

    CosmosSyncUser(CosmosUser asyncUser, CosmosSyncDatabase database, String id) {
        this.asyncUser = asyncUser;
        this.database = database;
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public CosmosSyncUserResponse read() throws CosmosClientException {
        return this.database.mapUserResponseAndBlock(this.asyncUser.read());
    }

    public CosmosSyncUserResponse replace(CosmosUserProperties userProperties) throws CosmosClientException {
        return this.database.mapUserResponseAndBlock(this.asyncUser.replace(userProperties));
    }

    public CosmosSyncUserResponse delete() throws CosmosClientException {
        return this.database.mapUserResponseAndBlock(this.asyncUser.delete());
    }
}

