/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosUserDefinedFunction;
import com.azure.data.cosmos.CosmosUserDefinedFunctionProperties;
import com.azure.data.cosmos.sync.CosmosSyncContainer;
import com.azure.data.cosmos.sync.CosmosSyncResponse;
import com.azure.data.cosmos.sync.CosmosSyncUserDefinedFunctionResponse;

public class CosmosSyncUserDefinedFunction {
    private final String id;
    private final CosmosSyncContainer container;
    private final CosmosUserDefinedFunction userDefinedFunction;

    CosmosSyncUserDefinedFunction(String id, CosmosSyncContainer container, CosmosUserDefinedFunction userDefinedFunction) {
        this.id = id;
        this.container = container;
        this.userDefinedFunction = userDefinedFunction;
    }

    public String id() {
        return this.id;
    }

    public CosmosSyncUserDefinedFunctionResponse read() throws CosmosClientException {
        return this.container.getScripts().mapUDFResponseAndBlock(this.userDefinedFunction.read());
    }

    public CosmosSyncUserDefinedFunctionResponse replace(CosmosUserDefinedFunctionProperties udfSettings) throws CosmosClientException {
        return this.container.getScripts().mapUDFResponseAndBlock(this.userDefinedFunction.replace(udfSettings));
    }

    public CosmosSyncResponse delete() throws CosmosClientException {
        return this.container.getScripts().mapDeleteResponseAndBlock(this.userDefinedFunction.delete());
    }
}

