/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AbstractReplicatorListener;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.cmd.Command;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.parser.AppendParser;
import com.moilioncircle.redis.replicator.cmd.parser.BRPopLPushParser;
import com.moilioncircle.redis.replicator.cmd.parser.BitFieldParser;
import com.moilioncircle.redis.replicator.cmd.parser.BitOpParser;
import com.moilioncircle.redis.replicator.cmd.parser.DecrByParser;
import com.moilioncircle.redis.replicator.cmd.parser.DecrParser;
import com.moilioncircle.redis.replicator.cmd.parser.DelParser;
import com.moilioncircle.redis.replicator.cmd.parser.EvalParser;
import com.moilioncircle.redis.replicator.cmd.parser.ExpireAtParser;
import com.moilioncircle.redis.replicator.cmd.parser.ExpireParser;
import com.moilioncircle.redis.replicator.cmd.parser.FlushAllParser;
import com.moilioncircle.redis.replicator.cmd.parser.FlushDBParser;
import com.moilioncircle.redis.replicator.cmd.parser.GeoAddParser;
import com.moilioncircle.redis.replicator.cmd.parser.GetSetParser;
import com.moilioncircle.redis.replicator.cmd.parser.HDelParser;
import com.moilioncircle.redis.replicator.cmd.parser.HIncrByParser;
import com.moilioncircle.redis.replicator.cmd.parser.HMSetParser;
import com.moilioncircle.redis.replicator.cmd.parser.HSetNxParser;
import com.moilioncircle.redis.replicator.cmd.parser.HSetParser;
import com.moilioncircle.redis.replicator.cmd.parser.IncrByParser;
import com.moilioncircle.redis.replicator.cmd.parser.IncrParser;
import com.moilioncircle.redis.replicator.cmd.parser.LInsertParser;
import com.moilioncircle.redis.replicator.cmd.parser.LPopParser;
import com.moilioncircle.redis.replicator.cmd.parser.LPushParser;
import com.moilioncircle.redis.replicator.cmd.parser.LPushXParser;
import com.moilioncircle.redis.replicator.cmd.parser.LRemParser;
import com.moilioncircle.redis.replicator.cmd.parser.LSetParser;
import com.moilioncircle.redis.replicator.cmd.parser.MSetNxParser;
import com.moilioncircle.redis.replicator.cmd.parser.MSetParser;
import com.moilioncircle.redis.replicator.cmd.parser.MoveParser;
import com.moilioncircle.redis.replicator.cmd.parser.PExpireAtParser;
import com.moilioncircle.redis.replicator.cmd.parser.PExpireParser;
import com.moilioncircle.redis.replicator.cmd.parser.PFAddParser;
import com.moilioncircle.redis.replicator.cmd.parser.PFCountParser;
import com.moilioncircle.redis.replicator.cmd.parser.PFMergeParser;
import com.moilioncircle.redis.replicator.cmd.parser.PSetExParser;
import com.moilioncircle.redis.replicator.cmd.parser.PersistParser;
import com.moilioncircle.redis.replicator.cmd.parser.PingParser;
import com.moilioncircle.redis.replicator.cmd.parser.PublishParser;
import com.moilioncircle.redis.replicator.cmd.parser.RPopParser;
import com.moilioncircle.redis.replicator.cmd.parser.RPushParser;
import com.moilioncircle.redis.replicator.cmd.parser.RPushXParser;
import com.moilioncircle.redis.replicator.cmd.parser.RenameNxParser;
import com.moilioncircle.redis.replicator.cmd.parser.RenameParser;
import com.moilioncircle.redis.replicator.cmd.parser.RestoreParser;
import com.moilioncircle.redis.replicator.cmd.parser.SAddParser;
import com.moilioncircle.redis.replicator.cmd.parser.SDiffStoreParser;
import com.moilioncircle.redis.replicator.cmd.parser.SInterStoreParser;
import com.moilioncircle.redis.replicator.cmd.parser.SMoveParser;
import com.moilioncircle.redis.replicator.cmd.parser.SRemParser;
import com.moilioncircle.redis.replicator.cmd.parser.SUnionStoreParser;
import com.moilioncircle.redis.replicator.cmd.parser.ScriptParser;
import com.moilioncircle.redis.replicator.cmd.parser.SelectParser;
import com.moilioncircle.redis.replicator.cmd.parser.SetBitParser;
import com.moilioncircle.redis.replicator.cmd.parser.SetExParser;
import com.moilioncircle.redis.replicator.cmd.parser.SetNxParser;
import com.moilioncircle.redis.replicator.cmd.parser.SetParser;
import com.moilioncircle.redis.replicator.cmd.parser.SetRangeParser;
import com.moilioncircle.redis.replicator.cmd.parser.UnLinkParser;
import com.moilioncircle.redis.replicator.cmd.parser.ZAddParser;
import com.moilioncircle.redis.replicator.cmd.parser.ZIncrByParser;
import com.moilioncircle.redis.replicator.cmd.parser.ZInterStoreParser;
import com.moilioncircle.redis.replicator.cmd.parser.ZRemParser;
import com.moilioncircle.redis.replicator.cmd.parser.ZUnionStoreParser;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.event.PostFullSyncEvent;
import com.moilioncircle.redis.replicator.event.PreFullSyncEvent;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbVisitor;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.AuxField;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleKey;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractReplicator
extends AbstractReplicatorListener
implements Replicator {
    protected Configuration configuration;
    protected RedisInputStream inputStream;
    protected RdbVisitor rdbVisitor = new DefaultRdbVisitor(this);
    protected final Map<ModuleKey, ModuleParser<? extends Module>> modules = new ConcurrentHashMap<ModuleKey, ModuleParser<? extends Module>>();
    protected final Map<CommandName, CommandParser<? extends Command>> commands = new ConcurrentHashMap<CommandName, CommandParser<? extends Command>>();

    @Override
    public CommandParser<? extends Command> getCommandParser(CommandName command) {
        return this.commands.get(command);
    }

    @Override
    public <T extends Command> void addCommandParser(CommandName command, CommandParser<T> parser) {
        this.commands.put(command, parser);
    }

    @Override
    public CommandParser<? extends Command> removeCommandParser(CommandName command) {
        return this.commands.remove(command);
    }

    @Override
    public ModuleParser<? extends Module> getModuleParser(String moduleName, int moduleVersion) {
        return this.modules.get(ModuleKey.key(moduleName, moduleVersion));
    }

    @Override
    public <T extends Module> void addModuleParser(String moduleName, int moduleVersion, ModuleParser<T> parser) {
        this.modules.put(ModuleKey.key(moduleName, moduleVersion), parser);
    }

    @Override
    public ModuleParser<? extends Module> removeModuleParser(String moduleName, int moduleVersion) {
        return this.modules.remove(ModuleKey.key(moduleName, moduleVersion));
    }

    public void submitEvent(Event event) {
        try {
            if (event instanceof KeyValuePair) {
                this.doRdbListener(this, (KeyValuePair)event);
            } else if (event instanceof Command) {
                this.doCommandListener(this, (Command)event);
            } else if (event instanceof PreFullSyncEvent) {
                this.doPreFullSync(this);
            } else if (event instanceof PostFullSyncEvent) {
                this.doPostFullSync(this, ((PostFullSyncEvent)event).getChecksum());
            } else if (event instanceof AuxField) {
                this.doAuxFieldListener(this, (AuxField)event);
            }
        }
        catch (Throwable e) {
            this.doExceptionListener(this, e, event);
        }
    }

    @Override
    public boolean verbose() {
        return this.configuration != null && this.configuration.isVerbose();
    }

    @Override
    public void setRdbVisitor(RdbVisitor rdbVisitor) {
        this.rdbVisitor = rdbVisitor;
    }

    @Override
    public RdbVisitor getRdbVisitor() {
        return this.rdbVisitor;
    }

    @Override
    public void builtInCommandParserRegister() {
        this.addCommandParser(CommandName.name("PING"), new PingParser());
        this.addCommandParser(CommandName.name("APPEND"), new AppendParser());
        this.addCommandParser(CommandName.name("SET"), new SetParser());
        this.addCommandParser(CommandName.name("SETEX"), new SetExParser());
        this.addCommandParser(CommandName.name("MSET"), new MSetParser());
        this.addCommandParser(CommandName.name("DEL"), new DelParser());
        this.addCommandParser(CommandName.name("SADD"), new SAddParser());
        this.addCommandParser(CommandName.name("HMSET"), new HMSetParser());
        this.addCommandParser(CommandName.name("HSET"), new HSetParser());
        this.addCommandParser(CommandName.name("LSET"), new LSetParser());
        this.addCommandParser(CommandName.name("EXPIRE"), new ExpireParser());
        this.addCommandParser(CommandName.name("EXPIREAT"), new ExpireAtParser());
        this.addCommandParser(CommandName.name("GETSET"), new GetSetParser());
        this.addCommandParser(CommandName.name("HSETNX"), new HSetNxParser());
        this.addCommandParser(CommandName.name("MSETNX"), new MSetNxParser());
        this.addCommandParser(CommandName.name("PSETEX"), new PSetExParser());
        this.addCommandParser(CommandName.name("SETNX"), new SetNxParser());
        this.addCommandParser(CommandName.name("SETRANGE"), new SetRangeParser());
        this.addCommandParser(CommandName.name("HDEL"), new HDelParser());
        this.addCommandParser(CommandName.name("LPOP"), new LPopParser());
        this.addCommandParser(CommandName.name("LPUSH"), new LPushParser());
        this.addCommandParser(CommandName.name("LPUSHX"), new LPushXParser());
        this.addCommandParser(CommandName.name("LRem"), new LRemParser());
        this.addCommandParser(CommandName.name("RPOP"), new RPopParser());
        this.addCommandParser(CommandName.name("RPUSH"), new RPushParser());
        this.addCommandParser(CommandName.name("RPUSHX"), new RPushXParser());
        this.addCommandParser(CommandName.name("ZREM"), new ZRemParser());
        this.addCommandParser(CommandName.name("RENAME"), new RenameParser());
        this.addCommandParser(CommandName.name("INCR"), new IncrParser());
        this.addCommandParser(CommandName.name("DECR"), new DecrParser());
        this.addCommandParser(CommandName.name("INCRBY"), new IncrByParser());
        this.addCommandParser(CommandName.name("DECRBY"), new DecrByParser());
        this.addCommandParser(CommandName.name("PERSIST"), new PersistParser());
        this.addCommandParser(CommandName.name("SELECT"), new SelectParser());
        this.addCommandParser(CommandName.name("FLUSHALL"), new FlushAllParser());
        this.addCommandParser(CommandName.name("FLUSHDB"), new FlushDBParser());
        this.addCommandParser(CommandName.name("HINCRBY"), new HIncrByParser());
        this.addCommandParser(CommandName.name("ZINCRBY"), new ZIncrByParser());
        this.addCommandParser(CommandName.name("MOVE"), new MoveParser());
        this.addCommandParser(CommandName.name("SMOVE"), new SMoveParser());
        this.addCommandParser(CommandName.name("PFADD"), new PFAddParser());
        this.addCommandParser(CommandName.name("PFCOUNT"), new PFCountParser());
        this.addCommandParser(CommandName.name("PFMERGE"), new PFMergeParser());
        this.addCommandParser(CommandName.name("SDIFFSTORE"), new SDiffStoreParser());
        this.addCommandParser(CommandName.name("SINTERSTORE"), new SInterStoreParser());
        this.addCommandParser(CommandName.name("SUNIONSTORE"), new SUnionStoreParser());
        this.addCommandParser(CommandName.name("ZADD"), new ZAddParser());
        this.addCommandParser(CommandName.name("ZINTERSTORE"), new ZInterStoreParser());
        this.addCommandParser(CommandName.name("ZUNIONSTORE"), new ZUnionStoreParser());
        this.addCommandParser(CommandName.name("BRPOPLPUSH"), new BRPopLPushParser());
        this.addCommandParser(CommandName.name("LINSERT"), new LInsertParser());
        this.addCommandParser(CommandName.name("RENAMENX"), new RenameNxParser());
        this.addCommandParser(CommandName.name("RESTORE"), new RestoreParser());
        this.addCommandParser(CommandName.name("PEXPIRE"), new PExpireParser());
        this.addCommandParser(CommandName.name("PEXPIREAT"), new PExpireAtParser());
        this.addCommandParser(CommandName.name("GEOADD"), new GeoAddParser());
        this.addCommandParser(CommandName.name("EVAL"), new EvalParser());
        this.addCommandParser(CommandName.name("SCRIPT"), new ScriptParser());
        this.addCommandParser(CommandName.name("PUBLISH"), new PublishParser());
        this.addCommandParser(CommandName.name("BITOP"), new BitOpParser());
        this.addCommandParser(CommandName.name("BITFIELD"), new BitFieldParser());
        this.addCommandParser(CommandName.name("SETBIT"), new SetBitParser());
        this.addCommandParser(CommandName.name("SREM"), new SRemParser());
        this.addCommandParser(CommandName.name("UNLINK"), new UnLinkParser());
    }

    protected void doClose() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.removeRawByteListener(this);
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.doCloseListener(this);
    }
}

