/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AbstractReplicator;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.DefaultExceptionListener;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.ReplyParser;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.AuxFieldListener;
import com.moilioncircle.redis.replicator.rdb.RdbListener;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedisAofReplicator
extends AbstractReplicator {
    protected static final Log logger = LogFactory.getLog(RedisAofReplicator.class);
    protected final ReplyParser replyParser;

    public RedisAofReplicator(File file, Configuration configuration) throws FileNotFoundException {
        this(new FileInputStream(file), configuration);
    }

    public RedisAofReplicator(InputStream in, Configuration configuration) {
        this.configuration = configuration;
        this.inputStream = new RedisInputStream(in, this.configuration.getBufferSize());
        this.inputStream.addRawByteListener(this);
        this.replyParser = new ReplyParser(this.inputStream);
        this.builtInCommandParserRegister();
        this.addExceptionListener(new DefaultExceptionListener());
    }

    @Override
    public void open() throws IOException {
        try {
            this.doOpen();
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.close();
        }
    }

    protected void doOpen() throws IOException {
        while (true) {
            Object obj;
            if ((obj = this.replyParser.parse()) instanceof Object[]) {
                Object[] command;
                CommandName cmdName;
                CommandParser operations;
                if (this.configuration.isVerbose() && logger.isDebugEnabled()) {
                    logger.debug((Object)Arrays.deepToString((Object[])obj));
                }
                if ((operations = (CommandParser)this.commands.get(cmdName = CommandName.name((String)(command = (Object[])obj)[0]))) == null) {
                    logger.warn((Object)("command [" + cmdName + "] not register. raw command:[" + Arrays.deepToString((Object[])obj) + "]"));
                    continue;
                }
                Object parsedCommand = operations.parse(command);
                this.submitEvent((Event)parsedCommand);
                continue;
            }
            logger.info((Object)("Redis reply:" + obj));
        }
    }

    @Override
    public void close() throws IOException {
        this.doClose();
    }

    @Override
    public ModuleParser<? extends Module> getModuleParser(String moduleName, int moduleVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Module> void addModuleParser(String moduleName, int moduleVersion, ModuleParser<T> parser) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModuleParser<? extends Module> removeModuleParser(String moduleName, int moduleVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRdbVisitor(RdbVisitor rdbVisitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RdbVisitor getRdbVisitor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addRdbListener(RdbListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRdbListener(RdbListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAuxFieldListener(AuxFieldListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAuxFieldListener(AuxFieldListener listener) {
        throw new UnsupportedOperationException();
    }
}

