/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.CloseListener;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.ExceptionListener;
import com.moilioncircle.redis.replicator.FileType;
import com.moilioncircle.redis.replicator.RedisAofReplicator;
import com.moilioncircle.redis.replicator.RedisMixReplicator;
import com.moilioncircle.redis.replicator.RedisRdbReplicator;
import com.moilioncircle.redis.replicator.RedisSocketReplicator;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.cmd.Command;
import com.moilioncircle.redis.replicator.cmd.CommandListener;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.rdb.AuxFieldListener;
import com.moilioncircle.redis.replicator.rdb.RdbListener;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class RedisReplicator
implements Replicator {
    protected final Replicator replicator;

    public RedisReplicator(File file, FileType fileType, Configuration configuration) throws FileNotFoundException {
        switch (fileType) {
            case AOF: {
                this.replicator = new RedisAofReplicator(file, configuration);
                break;
            }
            case RDB: {
                this.replicator = new RedisRdbReplicator(file, configuration);
                break;
            }
            case MIXED: {
                this.replicator = new RedisMixReplicator(file, configuration);
                break;
            }
            default: {
                throw new UnsupportedOperationException(fileType.toString());
            }
        }
    }

    public RedisReplicator(InputStream in, FileType fileType, Configuration configuration) {
        switch (fileType) {
            case AOF: {
                this.replicator = new RedisAofReplicator(in, configuration);
                break;
            }
            case RDB: {
                this.replicator = new RedisRdbReplicator(in, configuration);
                break;
            }
            case MIXED: {
                this.replicator = new RedisMixReplicator(in, configuration);
                break;
            }
            default: {
                throw new UnsupportedOperationException(fileType.toString());
            }
        }
    }

    public RedisReplicator(String host, int port, Configuration configuration) {
        this.replicator = new RedisSocketReplicator(host, port, configuration);
    }

    @Override
    public boolean addRdbListener(RdbListener listener) {
        return this.replicator.addRdbListener(listener);
    }

    @Override
    public boolean removeRdbListener(RdbListener listener) {
        return this.replicator.removeRdbListener(listener);
    }

    @Override
    public boolean addAuxFieldListener(AuxFieldListener listener) {
        return this.replicator.addAuxFieldListener(listener);
    }

    @Override
    public boolean removeAuxFieldListener(AuxFieldListener listener) {
        return this.replicator.removeAuxFieldListener(listener);
    }

    @Override
    public boolean addRdbRawByteListener(RawByteListener listener) {
        return this.replicator.addRdbRawByteListener(listener);
    }

    @Override
    public boolean removeRdbRawByteListener(RawByteListener listener) {
        return this.replicator.removeRdbRawByteListener(listener);
    }

    @Override
    public void builtInCommandParserRegister() {
        this.replicator.builtInCommandParserRegister();
    }

    @Override
    public CommandParser<? extends Command> getCommandParser(CommandName command) {
        return this.replicator.getCommandParser(command);
    }

    @Override
    public <T extends Command> void addCommandParser(CommandName command, CommandParser<T> parser) {
        this.replicator.addCommandParser(command, parser);
    }

    @Override
    public CommandParser<? extends Command> removeCommandParser(CommandName command) {
        return this.replicator.removeCommandParser(command);
    }

    @Override
    public ModuleParser<? extends Module> getModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.getModuleParser(moduleName, moduleVersion);
    }

    @Override
    public <T extends Module> void addModuleParser(String moduleName, int moduleVersion, ModuleParser<T> parser) {
        this.replicator.addModuleParser(moduleName, moduleVersion, parser);
    }

    @Override
    public ModuleParser<? extends Module> removeModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.removeModuleParser(moduleName, moduleVersion);
    }

    @Override
    public void setRdbVisitor(RdbVisitor rdbVisitor) {
        this.replicator.setRdbVisitor(rdbVisitor);
    }

    @Override
    public RdbVisitor getRdbVisitor() {
        return this.replicator.getRdbVisitor();
    }

    @Override
    public boolean addCommandListener(CommandListener listener) {
        return this.replicator.addCommandListener(listener);
    }

    @Override
    public boolean removeCommandListener(CommandListener listener) {
        return this.replicator.removeCommandListener(listener);
    }

    @Override
    public boolean addCloseListener(CloseListener listener) {
        return this.replicator.addCloseListener(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        return this.replicator.removeCloseListener(listener);
    }

    @Override
    public boolean addExceptionListener(ExceptionListener listener) {
        return this.replicator.addExceptionListener(listener);
    }

    @Override
    public boolean removeExceptionListener(ExceptionListener listener) {
        return this.replicator.removeExceptionListener(listener);
    }

    @Override
    public boolean verbose() {
        return this.replicator.verbose();
    }

    @Override
    public void open() throws IOException {
        this.replicator.open();
    }

    @Override
    public void close() throws IOException {
        this.replicator.close();
    }

    @Override
    public void handle(byte ... rawBytes) {
        this.replicator.handle(rawBytes);
    }
}

