/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd;

import com.moilioncircle.redis.replicator.cmd.BulkReplyHandler;
import com.moilioncircle.redis.replicator.cmd.OffsetHandler;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.util.ByteBuilder;
import java.io.IOException;

public class ReplyParser {
    private final RedisInputStream in;

    public ReplyParser(RedisInputStream in) {
        this.in = in;
    }

    public Object parse() throws IOException {
        return this.parse(new BulkReplyHandler.SimpleBulkReplyHandler(), null);
    }

    public Object parse(OffsetHandler offsetHandler) throws IOException {
        return this.parse(new BulkReplyHandler.SimpleBulkReplyHandler(), offsetHandler);
    }

    public Object parse(BulkReplyHandler handler, OffsetHandler offsetHandler) throws IOException {
        this.in.mark();
        Object rs = this.parse(handler);
        long len = this.in.unmark();
        if (offsetHandler != null) {
            offsetHandler.handle(len);
        }
        return rs;
    }

    public Object parse(BulkReplyHandler handler) throws IOException {
        int c = this.in.read();
        switch (c) {
            case 36: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) break;
                    builder.put((byte)c);
                }
                long len = Long.parseLong(builder.toString());
                if (len == -1L) {
                    return null;
                }
                if (handler != null) {
                    return handler.handle(len, this.in);
                }
                throw new AssertionError((Object)"callback is null");
            }
            case 58: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) break;
                    builder.put((byte)c);
                }
                return Long.parseLong(builder.toString());
            }
            case 42: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) break;
                    builder.put((byte)c);
                }
                long len = Long.parseLong(builder.toString());
                if (len == -1L) {
                    return null;
                }
                Object[] ary = new Object[(int)len];
                int i = 0;
                while ((long)i < len) {
                    Object obj;
                    ary[i] = obj = this.parse(new BulkReplyHandler.SimpleBulkReplyHandler());
                    ++i;
                }
                return ary;
            }
            case 43: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) {
                        return builder.toString();
                    }
                    builder.put((byte)c);
                }
            }
            case 45: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) {
                        return builder.toString();
                    }
                    builder.put((byte)c);
                }
            }
            case 10: {
                return this.parse(handler);
            }
        }
        throw new AssertionError((Object)("Expect [$,:,*,+,-] but: " + (char)c));
    }
}

