/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.BitFieldCommand;
import com.moilioncircle.redis.replicator.cmd.impl.GetTypeOffset;
import com.moilioncircle.redis.replicator.cmd.impl.IncrByTypeOffsetIncrement;
import com.moilioncircle.redis.replicator.cmd.impl.OverFlow;
import com.moilioncircle.redis.replicator.cmd.impl.OverFlowType;
import com.moilioncircle.redis.replicator.cmd.impl.SetTypeOffsetValue;
import com.moilioncircle.redis.replicator.cmd.impl.Statement;
import java.util.ArrayList;
import java.util.List;

public class BitFieldParser
implements CommandParser<BitFieldCommand> {
    @Override
    public BitFieldCommand parse(Object[] command) {
        int idx = 1;
        String key = (String)command[idx++];
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (idx < command.length) {
            String token;
            while ((idx = this.parseStatement(idx, command, list)) < command.length && (token = (String)command[idx]) != null && (token.equalsIgnoreCase("GET") || token.equalsIgnoreCase("SET") || token.equalsIgnoreCase("INCRBY"))) {
            }
        }
        ArrayList<OverFlow> overFlowList = null;
        if (idx < command.length) {
            overFlowList = new ArrayList<OverFlow>();
            do {
                OverFlow overFlow = new OverFlow();
                idx = this.parseOverFlow(idx, command, overFlow);
                overFlowList.add(overFlow);
            } while (idx < command.length && ((String)command[idx]).equalsIgnoreCase("OVERFLOW"));
        }
        return new BitFieldCommand(key, list, overFlowList);
    }

    private int parseOverFlow(int i, Object[] params, OverFlow overFlow) {
        int idx = i;
        this.accept((String)params[idx++], "OVERFLOW");
        OverFlowType overFlowType = null;
        String keyWord = (String)params[idx++];
        if (keyWord.equalsIgnoreCase("WRAP")) {
            overFlowType = OverFlowType.WRAP;
        } else if (keyWord.equalsIgnoreCase("SAT")) {
            overFlowType = OverFlowType.SAT;
        } else if (keyWord.equalsIgnoreCase("FAIL")) {
            overFlowType = OverFlowType.FAIL;
        } else {
            throw new AssertionError((Object)("parse [BITFIELD] command error." + keyWord));
        }
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (idx < params.length) {
            String token;
            while ((idx = this.parseStatement(idx, params, list)) < params.length && (token = (String)params[idx]) != null && (token.equalsIgnoreCase("GET") || token.equalsIgnoreCase("SET") || token.equalsIgnoreCase("INCRBY"))) {
            }
        }
        overFlow.setOverFlowType(overFlowType);
        overFlow.setStatements(list);
        return idx;
    }

    private int parseStatement(int i, Object[] params, List<Statement> list) {
        int idx = i;
        String keyWord = (String)params[idx++];
        Statement statement = null;
        if (keyWord.equalsIgnoreCase("GET")) {
            GetTypeOffset getTypeOffset = new GetTypeOffset();
            idx = this.parseGet(idx - 1, params, getTypeOffset);
            statement = getTypeOffset;
        } else if (keyWord.equalsIgnoreCase("SET")) {
            SetTypeOffsetValue setTypeOffsetValue = new SetTypeOffsetValue();
            idx = this.parseSet(idx - 1, params, setTypeOffsetValue);
            statement = setTypeOffsetValue;
        } else if (keyWord.equalsIgnoreCase("INCRBY")) {
            IncrByTypeOffsetIncrement incrByTypeOffsetIncrement = new IncrByTypeOffsetIncrement();
            idx = this.parseIncrBy(idx - 1, params, incrByTypeOffsetIncrement);
            statement = incrByTypeOffsetIncrement;
        } else {
            return i;
        }
        list.add(statement);
        return idx;
    }

    private int parseIncrBy(int i, Object[] params, IncrByTypeOffsetIncrement incrByTypeOffsetIncrement) {
        int idx = i;
        this.accept((String)params[idx++], "INCRBY");
        String type = (String)params[idx++];
        String offset = (String)params[idx++];
        int increment = Integer.parseInt((String)params[idx++]);
        incrByTypeOffsetIncrement.setType(type);
        incrByTypeOffsetIncrement.setOffset(offset);
        incrByTypeOffsetIncrement.setIncrement(increment);
        return idx;
    }

    private int parseSet(int i, Object[] params, SetTypeOffsetValue setTypeOffsetValue) {
        int idx = i;
        this.accept((String)params[idx++], "SET");
        String type = (String)params[idx++];
        String offset = (String)params[idx++];
        int value = Integer.parseInt((String)params[idx++]);
        setTypeOffsetValue.setType(type);
        setTypeOffsetValue.setOffset(offset);
        setTypeOffsetValue.setValue(value);
        return idx;
    }

    private int parseGet(int i, Object[] params, GetTypeOffset getTypeOffset) {
        int idx = i;
        this.accept((String)params[idx++], "GET");
        String type = (String)params[idx++];
        String offset = (String)params[idx++];
        getTypeOffset.setType(type);
        getTypeOffset.setOffset(offset);
        return idx;
    }

    private void accept(String actual, String expect) {
        if (actual.equalsIgnoreCase(expect)) {
            return;
        }
        throw new AssertionError((Object)("Expect " + expect + " but actual " + actual));
    }
}

