/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.ExistType;
import com.moilioncircle.redis.replicator.cmd.impl.ZAddCommand;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import java.util.ArrayList;

public class ZAddParser
implements CommandParser<ZAddCommand> {
    @Override
    public ZAddCommand parse(Object[] command) {
        int idx = 1;
        Boolean isCh = null;
        Boolean isIncr = null;
        ExistType existType = ExistType.NONE;
        ArrayList<ZSetEntry> list = new ArrayList<ZSetEntry>();
        String key = (String)command[idx++];
        boolean et = false;
        while (idx < command.length) {
            String param = (String)command[idx];
            if (!et && param.equalsIgnoreCase("NX")) {
                existType = ExistType.NX;
                et = true;
                ++idx;
                continue;
            }
            if (!et && param.equalsIgnoreCase("XX")) {
                existType = ExistType.XX;
                et = true;
                ++idx;
                continue;
            }
            if (isCh == null && param.equalsIgnoreCase("CH")) {
                isCh = true;
            } else if (isIncr == null && param.equalsIgnoreCase("INCR")) {
                isIncr = true;
            } else {
                double score = Double.parseDouble(param);
                String member = (String)command[++idx];
                list.add(new ZSetEntry(member, score));
            }
            ++idx;
        }
        ZSetEntry[] zSetEntries = new ZSetEntry[list.size()];
        list.toArray(zSetEntries);
        return new ZAddCommand(key, existType, isCh, isIncr, zSetEntries);
    }
}

