/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.AggregateType;
import com.moilioncircle.redis.replicator.cmd.impl.ZInterStoreCommand;

public class ZInterStoreParser
implements CommandParser<ZInterStoreCommand> {
    @Override
    public ZInterStoreCommand parse(Object[] command) {
        int idx = 1;
        AggregateType aggregateType = null;
        String destination = (String)command[idx++];
        int numkeys = Integer.parseInt((String)command[idx++]);
        String[] keys = new String[numkeys];
        for (int i = 0; i < numkeys; ++i) {
            keys[i] = (String)command[idx++];
        }
        double[] weights = null;
        while (idx < command.length) {
            String param = (String)command[idx];
            if (param.equalsIgnoreCase("WEIGHTS")) {
                ++idx;
                weights = new double[numkeys];
                for (int i = 0; i < numkeys; ++i) {
                    weights[i] = Double.parseDouble((String)command[idx++]);
                }
            }
            if (!param.equalsIgnoreCase("AGGREGATE")) continue;
            int n = ++idx;
            ++idx;
            String next = (String)command[n];
            if (next.equalsIgnoreCase("SUM")) {
                aggregateType = AggregateType.SUM;
                continue;
            }
            if (next.equalsIgnoreCase("MIN")) {
                aggregateType = AggregateType.MIN;
                continue;
            }
            if (!next.equalsIgnoreCase("MAX")) continue;
            aggregateType = AggregateType.MAX;
        }
        return new ZInterStoreCommand(destination, numkeys, keys, weights, aggregateType);
    }
}

