/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import com.moilioncircle.redis.replicator.util.ByteArray;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected long pos = 0L;
    protected long count;
    protected long mark = 0L;
    protected ByteArray buf;

    public ByteArrayInputStream(ByteArray buf) {
        this.buf = buf;
        this.count = buf.length();
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf.get(this.pos++) & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = (int)(this.count - this.pos);
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        ByteArray.arraycopy(this.buf, this.pos, new ByteArray(b), off, len);
        this.pos += (long)len;
        return len;
    }

    @Override
    public long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos += k;
        return k;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }
}

