/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.util.ByteArray;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class RedisInputStream
extends InputStream {
    protected int head = 0;
    protected int tail = 0;
    protected long total = 0L;
    protected long markLen = 0L;
    protected final byte[] buf;
    protected boolean mark = false;
    protected final InputStream in;
    protected final List<RawByteListener> listeners = new CopyOnWriteArrayList<RawByteListener>();

    public RedisInputStream(InputStream in) {
        this(in, 8192);
    }

    public RedisInputStream(InputStream in, int len) {
        this.in = in;
        this.buf = new byte[len];
    }

    public void addRawByteListener(RawByteListener listener) {
        this.listeners.add(listener);
    }

    public void removeRawByteListener(RawByteListener listener) {
        this.listeners.remove(listener);
    }

    protected void notify(byte ... bytes) {
        for (RawByteListener listener : this.listeners) {
            listener.handle(bytes);
        }
    }

    public int head() {
        return this.head;
    }

    public int tail() {
        return this.tail;
    }

    public int bufSize() {
        return this.buf.length;
    }

    public void mark() {
        if (!this.mark) {
            this.mark = true;
            return;
        }
        throw new AssertionError((Object)"already marked");
    }

    public long unmark() {
        if (this.mark) {
            long rs = this.markLen;
            this.markLen = 0L;
            this.mark = false;
            return rs;
        }
        throw new AssertionError((Object)"must mark first");
    }

    public long total() {
        return this.total;
    }

    public ByteArray readBytes(long len) throws IOException {
        ByteArray bytes = new ByteArray(len);
        this.read(bytes, 0L, len);
        if (this.mark) {
            this.markLen += len;
        }
        return bytes;
    }

    public int readInt(int len) throws IOException {
        return this.readInt(len, true);
    }

    public long readLong(int len) throws IOException {
        return this.readLong(len, true);
    }

    public int readInt(int length, boolean littleEndian) throws IOException {
        int r = 0;
        for (int i = 0; i < length; ++i) {
            int v = this.read();
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        int c = 4 - length << 3;
        return r << c >> c;
    }

    public long readUInt(int length) throws IOException {
        return this.readUInt(length, true);
    }

    public long readUInt(int length, boolean littleEndian) throws IOException {
        return (long)this.readInt(length, littleEndian) & 0xFFFFFFFFL;
    }

    public int readInt(byte[] bytes) {
        return this.readInt(bytes, true);
    }

    public int readInt(byte[] bytes, boolean littleEndian) {
        int r = 0;
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            int v = bytes[i] & 0xFF;
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        int c = 4 - length << 3;
        return r << c >> c;
    }

    public long readLong(int length, boolean littleEndian) throws IOException {
        long r = 0L;
        for (int i = 0; i < length; ++i) {
            long v = this.read();
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        return r;
    }

    public String readString(int len) throws IOException {
        return this.readString(len, Constants.CHARSET);
    }

    public String readString(int len, Charset charset) throws IOException {
        byte[] original = this.readBytes(len).first();
        return new String(original, charset);
    }

    @Override
    public int read() throws IOException {
        if (this.head >= this.tail) {
            this.fill();
        }
        if (this.mark) {
            ++this.markLen;
        }
        byte b = this.buf[this.head++];
        this.notify(b);
        return b & 0xFF;
    }

    public long read(ByteArray bytes, long offset, long len) throws IOException {
        int available;
        long index = offset;
        for (long total = len; total > 0L; total -= (long)available) {
            available = this.tail - this.head;
            if ((long)available >= total) {
                ByteArray.arraycopy(new ByteArray(this.buf), this.head, bytes, index, total);
                this.head = (int)((long)this.head + total);
                break;
            }
            ByteArray.arraycopy(new ByteArray(this.buf), this.head, bytes, index, available);
            index += (long)available;
            this.fill();
        }
        for (byte[] b : bytes) {
            this.notify(b);
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.tail - this.head + this.in.available();
    }

    @Override
    public long skip(long len) throws IOException {
        int available;
        for (long total = len; total > 0L; total -= (long)available) {
            available = this.tail - this.head;
            if ((long)available >= total) {
                this.head = (int)((long)this.head + total);
                break;
            }
            this.fill();
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    protected void fill() throws IOException {
        this.tail = this.in.read(this.buf, 0, this.buf.length);
        if (this.tail == -1) {
            throw new EOFException("end of file.");
        }
        this.total += (long)this.tail;
        this.head = 0;
    }
}

